-- 001_categories.sql
CREATE TABLE IF NOT EXISTS categories (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(120) NOT NULL,
  slug VARCHAR(140) NOT NULL UNIQUE,
  color VARCHAR(16) NULL,
  position INT NOT NULL DEFAULT 0,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

ALTER TABLE forms
  ADD COLUMN IF NOT EXISTS category_id INT NULL;

ALTER TABLE forms
  ADD CONSTRAINT fk_forms_category
    FOREIGN KEY (category_id) REFERENCES categories(id)
    ON DELETE SET NULL;

INSERT INTO categories (name, slug, color, position) VALUES
('Recebimento','recebimento','#1565c0',1),
('Qualidade','qualidade','#2e7d32',2),
('Produção','producao','#6d28d9',3),
('Higiene/5S','higiene-5s','#ef6c00',4),
('Auditorias','auditorias','#ad1457',5)
ON DUPLICATE KEY UPDATE name=VALUES(name), color=VALUES(color), position=VALUES(position);
