<?php
session_start();
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/global_search.php';
require_login();

$pdo = db();
$user = auth_user();

// categorias
$cats = $pdo->query("SELECT c.id,c.name,c.color, COUNT(f.id) cnt
                     FROM categories c
                     LEFT JOIN forms f ON f.category_id=c.id
                     GROUP BY c.id ORDER BY c.position,c.name")->fetchAll();

// filtros
$cat = isset($_GET['cat']) ? (int)$_GET['cat'] : null;
$q = trim($_GET['q'] ?? '');
$page = max(1, (int)($_GET['page'] ?? 1));
$per = 12;
$off = ($page-1)*$per;

// query de formulários
$sql = "FROM forms f WHERE 1=1";
$params = [];
if ($cat) { $sql .= " AND f.category_id=?"; $params[] = $cat; }
if ($q !== '') { $sql .= " AND (f.name LIKE ? OR f.slug LIKE ?)"; $params[] = "%$q%"; $params[] = "%$q%"; }

$total = $pdo->prepare("SELECT COUNT(*) ".$sql); $total->execute($params); $total = (int)$total->fetchColumn();
$st = $pdo->prepare("SELECT f.* ".$sql." ORDER BY f.updated_at DESC, f.created_at DESC, f.name LIMIT $per OFFSET $off"); $st->execute($params);
$forms = $st->fetchAll();
$pages = max(1, (int)ceil($total / $per));
?>
<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <title>Formulários</title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link rel="manifest" href="/manifest.json">
  <meta name="theme-color" content="#1976d2">
  <script>if('serviceWorker' in navigator){navigator.serviceWorker.register('/service-worker.js');}</script>
<?php echo "<script>window.CURRENT_USER=".json_encode($user, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES).";</script>"; ?>
  <link rel="stylesheet" href="assets/css/styles.css">
  <style>
    .layout{display:grid; grid-template-columns:260px 1fr; gap:16px}
    @media (max-width:900px){ .layout{grid-template-columns:1fr} }
    .sidebar{border:1px solid var(--border);border-radius:12px;background:#fff;padding:12px;display:flex;flex-direction:column;gap:10px}
    .sidebar .nav a{display:flex;align-items:center;gap:8px;padding:8px;border-radius:8px;text-decoration:none;color:inherit;border:1px solid transparent}
    .sidebar .nav a.active,.sidebar .nav a:hover{background:var(--surface);border-color:var(--border)}
    .header{display:flex;gap:8px;align-items:center;margin-bottom:10px}
    .cards{display:grid;grid-template-columns:repeat(3,1fr);gap:10px}
    @media (max-width:1100px){ .cards{grid-template-columns:repeat(2,1fr)} }
    @media (max-width:700px){ .cards{grid-template-columns:1fr} }
    .card h3{margin:0 0 6px}
    .muted{color:#666}
  </style>
</head>
<body>
<div class="container">
  <div class="header">
    <a class="btn is-primary" href="new_form.php">Novo formulário</a>
    <form method="get" class="btn-row" style="margin:0 0 0 8px">
      <input type="hidden" name="cat" value="<?=htmlspecialchars((string)$cat)?>">
      <input type="search" name="q" value="<?=htmlspecialchars($q)?>" placeholder="Buscar formulário...">
      <button class="btn">Buscar</button>
    </form>
    <span class="spacer"></span>
    <div class="btn-row">
      <a class="btn" href="outbox.html">Caixa de Saída <span id="outbox-badge" class="badge" style="display:none"></span></a>
      <span id="net-state" class="badge" style="margin-right:6px">Online</span><a class="btn" href="logout.php">Sair (<?=htmlspecialchars($user['display_name']??$user['username'])?>)</a>
    </div>
  </div>

  <div class="layout">
    <aside class="sidebar">
      <div class="nav">
        <a href="outbox.html">Caixa de Saída <span id="outbox-badge-side" class="badge" style="display:none"></span></a>
        <a href="index.php" class="<?= !$cat ? 'active':'' ?>">Todas</a>
        <?php foreach($cats as $c): ?>
          <a href="?cat=<?=$c['id']?><?= $q ? '&q='.urlencode($q):'' ?>" class="<?= ($cat===$c['id'])?'active':'' ?>" data-cat-id="<?=$c['id']?>">
            <span class="badge" style="border-color:<?=$c['color']?>;color:<?=$c['color']?>">●</span>
            <?=htmlspecialchars($c['name'])?> (<?=$c['cnt']?>) <span class="badge" id="catq-<?=$c['id']?>" style="display:none"></span>
          </a>
        <?php endforeach; ?>
      </div>
      <div style="margin-top:auto">
        <?= global_search_box('') ?>
      </div>
    </aside>

    <main>
      <?php if(!$forms): ?>
        <div class="card">Nenhum formulário encontrado.</div>
      <?php else: ?>
        <div class="cards">
          <?php foreach($forms as $f): ?>
            <div class="card">
              <h3><?=htmlspecialchars($f['name'])?></h3>
              <div class="muted" style="font-size:.9em"><?=htmlspecialchars($f['slug'])?></div>
              <div class="btn-row" style="margin-top:8px">
                <a class="btn" href="builder_dnd.php?id=<?=$f['id']?>">Gerenciar</a>
                <a class="btn" href="render.php?form_id=<?=$f['id']?>">Preencher</a>
                <a class="btn" href="submissions.php?form_id=<?=$f['id']?>">Registros</a>
              </div>
            </div>
          <?php endforeach; ?>
        </div>
        <?php if($pages>1): ?>
          <div class="pager" style="margin-top:12px">
            <?php for($i=1;$i<=$pages;$i++): $u='?page='.$i.($cat?'&cat='.$cat:'').($q!==''?'&q='.urlencode($q):''); ?>
              <a class="page <?= $i===$page?'active':'' ?>" href="<?=$u?>"><?=$i?></a>
            <?php endfor; ?>
          </div>
        <?php endif; ?>
      <?php endif; ?>
    </main>
  </div>
</div>

<script type="module">
import { pendingCount } from '/js/offline-queue.js';

const badge = document.getElementById('outbox-badge');
const net = document.getElementById('net-state');

async function refreshBadge(){
  try{
    const c = await pendingCount();
    if (!badge) return;
    if (c > 0){
      badge.textContent = c;
      badge.style.display = 'inline-block';
    } else {
      badge.style.display = 'none';
    }
  }catch(e){ /* silenciar */ }
}
function refreshNet(){
  if (!net) return;
  const online = navigator.onLine;
  net.textContent = online ? 'Online' : 'Offline';
  net.className = 'badge ' + (online ? 'ok' : 'err');
}

addEventListener('queuechange', refreshBadge);
addEventListener('online', () => { refreshNet(); refreshBadge(); });
addEventListener('offline', () => { refreshNet(); });

refreshNet();
refreshBadge();
</script>


<script type="module">
import { pendingCount } from '/js/offline-queue.js';

const topBadge = document.getElementById('outbox-badge');
const sideBadge = document.getElementById('outbox-badge-side');
const net = document.getElementById('net-state');

async function refreshBadges(){
  try{
    const c = await pendingCount(true);
    for (const b of [topBadge, sideBadge]){
      if (!b) continue;
      if (c > 0){ b.textContent = c; b.style.display = 'inline-block'; }
      else { b.style.display = 'none'; }
    }
  }catch(e){}
}
function refreshNet(){
  if (!net) return;
  const online = navigator.onLine;
  net.textContent = online ? 'Online' : 'Offline';
  net.className = 'badge ' + (online ? 'ok' : 'err');
}

addEventListener('queuechange', refreshBadges);
addEventListener('online', () => { refreshNet(); refreshBadges(); });
addEventListener('offline', () => { refreshNet(); });

refreshNet();
refreshBadges();
</script>


<script type="module">
import { queueAll, pendingCount } from '/js/offline-queue.js';
import { getFormsMeta } from '/js/forms-meta.js';

const topBadge = document.getElementById('outbox-badge');
const sideBadge = document.getElementById('outbox-badge-side');
const net = document.getElementById('net-state');

function username(){ try{ return (window.CURRENT_USER && (CURRENT_USER.username||CURRENT_USER.display_name)) || null; }catch(e){ return null; } }

async function refreshOutboxBadges(){
  const c = await pendingCount(true);
  for (const b of [topBadge, sideBadge]){
    if (!b) continue;
    if (c>0){ b.textContent=c; b.style.display='inline-block'; } else { b.style.display='none'; }
  }
}

async function refreshCategoryQueuedBadges(){
  const list = await queueAll();
  const user = username();
  const items = user ? list.filter(p => (p.user||null) === user) : list;
  if (!items.length){ document.querySelectorAll('[id^=catq-]').forEach(x=>x.style.display='none'); return; }
  const meta = await getFormsMeta();
  const mapFormToCat = new Map(meta.map(m => [String(m.id), m.category_id || 0]));
  const counts = {};
  for (const it of items){
    const catId = String(mapFormToCat.get(String(it.form_id||'')) || '0');
    if (!counts[catId]) counts[catId]=0;
    counts[catId]++;
  }
  for (const [catId, cnt] of Object.entries(counts)){
    if (catId==='0') continue; // sem categoria
    const el = document.getElementById('catq-'+catId);
    if (el){ el.textContent = '+'+cnt; el.style.display='inline-block'; }
  }
}

function refreshNet(){
  if (!net) return;
  const online = navigator.onLine;
  net.textContent = online ? 'Online' : 'Offline';
  net.className = 'badge ' + (online ? 'ok' : 'err');
}

addEventListener('queuechange', ()=>{ refreshOutboxBadges(); refreshCategoryQueuedBadges(); });
addEventListener('online', ()=>{ refreshNet(); refreshOutboxBadges(); refreshCategoryQueuedBadges(); });
addEventListener('offline', ()=>{ refreshNet(); });

refreshNet();
refreshOutboxBadges();
refreshCategoryQueuedBadges();
</script>

</body>
</html>
