export async function getFormsMeta() {
  const KEY = 'forms_meta_cache';
  const maxAge = 24*60*60*1000; // 1 dia
  const cached = localStorage.getItem(KEY);
  if (cached) {
    try{
      const obj = JSON.parse(cached);
      if (obj && (Date.now() - (obj.at||0) < maxAge)) return obj.data || [];
    }catch(e){}
  }
  try{
    const res = await fetch('/forms_meta.php', { credentials:'same-origin' });
    if (!res.ok) throw new Error('HTTP '+res.status);
    const data = await res.json();
    localStorage.setItem(KEY, JSON.stringify({ at: Date.now(), data }));
    return data;
  }catch(e){
    if (cached) try{ return JSON.parse(cached).data || []; }catch(_) {}
    return [];
  }
}