-- DEMO schema (7 formulários + 7 registros cada) com categorias e layout padrão
SET NAMES utf8mb4;
SET time_zone = '+00:00';

CREATE TABLE IF NOT EXISTS categories (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(120) NOT NULL,
  slug VARCHAR(140) NOT NULL UNIQUE,
  color VARCHAR(16) NULL,
  position INT NOT NULL DEFAULT 0,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS forms (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(191) NOT NULL,
  slug VARCHAR(191) NOT NULL UNIQUE,
  category_id INT NULL,
  schema_json JSON NOT NULL,
  html_layout MEDIUMTEXT NULL,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at DATETIME NULL,
  CONSTRAINT fk_forms_category FOREIGN KEY (category_id) REFERENCES categories(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS form_versions (
  id INT AUTO_INCREMENT PRIMARY KEY,
  form_id INT NOT NULL,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  user VARCHAR(191) NULL,
  note VARCHAR(191) NULL,
  schema_json JSON NOT NULL,
  KEY idx_form (form_id),
  KEY idx_created (created_at),
  CONSTRAINT fk_form_versions_form FOREIGN KEY (form_id) REFERENCES forms(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS submissions (
  id INT AUTO_INCREMENT PRIMARY KEY,
  form_id INT NOT NULL,
  user VARCHAR(191) NULL,
  submitted_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at DATETIME NULL,
  updated_by VARCHAR(191) NULL,
  KEY idx_form (form_id),
  KEY idx_submitted (submitted_at),
  KEY idx_updated (updated_at),
  CONSTRAINT fk_submissions_form FOREIGN KEY (form_id) REFERENCES forms(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS submission_values (
  id INT AUTO_INCREMENT PRIMARY KEY,
  submission_id INT NOT NULL,
  field_name VARCHAR(191) NOT NULL,
  field_value MEDIUMTEXT NULL,
  KEY idx_sub (submission_id),
  KEY idx_field (field_name),
  FULLTEXT KEY ft_value (field_value),
  CONSTRAINT fk_sub_values_sub FOREIGN KEY (submission_id) REFERENCES submissions(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  username VARCHAR(80) NOT NULL UNIQUE,
  email VARCHAR(191) NULL UNIQUE,
  display_name VARCHAR(120) NULL,
  password_hash VARCHAR(255) NOT NULL,
  role ENUM('admin','manager','user') NOT NULL DEFAULT 'user',
  sector VARCHAR(80) NULL,
  is_active TINYINT(1) NOT NULL DEFAULT 1,
  failed_attempts INT NOT NULL DEFAULT 0,
  lock_until DATETIME NULL,
  last_login DATETIME NULL,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at DATETIME NULL,
  KEY idx_role (role),
  KEY idx_sector (sector)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO users (username,email,display_name,password_hash,role,sector) VALUES
('admin','admin@local','Administrador','$2y$10$JmP6tG9c3ZQX3x7xNf0C9Oa0Qj3Xv2lG3Fz9Z9u2tP7JzYVx2q3nS','admin','qualidade')
ON DUPLICATE KEY UPDATE username=username;

INSERT INTO categories (name, slug, color, position) VALUES
('Recebimento','recebimento','#1565c0',1),
('Qualidade','qualidade','#2e7d32',2),
('Produção','producao','#6d28d9',3),
('Higiene/5S','higiene-5s','#ef6c00',4),
('Auditorias','auditorias','#ad1457',5)
ON DUPLICATE KEY UPDATE name=VALUES(name), color=VALUES(color), position=VALUES(position);

START TRANSACTION;
INSERT INTO forms (id, name, slug, category_id, schema_json, html_layout, created_at) VALUES (1, 'Check-list de Recebimento', 'check-list-de-recebimento', 1, '{"fill_columns": 1, "steps": [{"title": "Dados", "columns": 2, "fields": [{"name": "data", "label": "Data", "type": "date", "required": true}, {"name": "turno", "label": "Turno", "type": "select", "options": ["Manhã", "Tarde", "Noite"], "required": true}, {"name": "responsavel", "label": "Responsável", "type": "text", "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "status", "label": "Status", "type": "select", "options": ["Conforme", "Parcial", "Não conforme", "Fechado"], "required": true, "editable_by": ["qualidade", "supervisor"]}, {"name": "owner_role", "label": "Dono atual (setor)", "type": "select", "options": ["recebimento", "qualidade", "supervisor"], "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "descricao", "label": "Descrição", "type": "textarea", "required": false}, {"name": "anexo", "label": "Anexo", "type": "file", "required": false}, {"name": "assinatura", "label": "Assinatura", "type": "signature", "required": false}]}]}', '<!— cole tudo no Editor de Layout —>
<div class="sheet" id="sheet" data-status="{{status}}" data-tema="light">
  <header class="print-header">
    <div class="left">
      <img src="{{logo_url}}" alt="logo" onerror="this.style.display=''none''" />
      <span class="empresa">{{empresa}}</span>
      <span class="form-name">{{form_name}}</span>
    </div>
    <div class="right">
      <div><strong>Protocolo:</strong> <span id="proto">{{protocolo}}{{submission_id}}</span></div>
      <div><strong>Data:</strong> {{data}}</div>
    </div>
  </header>
  <footer class="print-footer">
    Gerado por <strong>{{usuario}}</strong> em <strong>{{impresso_em}}</strong>
    <span class="spacer"></span>
    <span class="page-counter">Página <span class="pageNumber"></span> / <span class="totalPages"></span></span>
  </footer>
  <div class="wm" id="wm">NÃO CONFORME</div>
  <div class="stamp" id="stamp">{{status}}</div>
  <div class="actions no-print">
    <button class="btn" onclick="toggleTheme()">Alternar tema</button>
    <button class="btn" onclick="window.print()">Imprimir</button>
  </div>
  <section class="grid2 card">
    <div><label>Responsável</label><div class="val">{{responsavel}}</div></div>
    <div><label>Setor atual</label><div class="val">{{owner_role}}</div></div>
    <div><label>Status</label><div class="val">{{status}}</div></div>
    <div><label>Turno</label><div class="val">{{turno}}</div></div>
  </section>
  <section class="card">
    <h3>Descrição</h3>
    <div class="pre">{{descricao}}</div>
  </section>
  <section class="card">
    <h3>Itens</h3>
    <table class="tbl" id="tbl-itens">
      <thead><tr><th>Item</th><th class="num">Qtde</th><th>Unid</th></tr></thead>
      <tbody>
        {{#each itens}}
          <tr><td>{{descricao}}</td><td class="num">{{qtde}}</td><td>{{un}}</td></tr>
        {{/each}}
      </tbody>
      <tfoot><tr><th>Total</th><th class="num">{{sum itens.qtde}}</th><th></th></tr></tfoot>
    </table>
  </section>
  <section class="card">
    <h3>Fotos</h3>
    <div class="fotos" id="fotos"></div>
    <small class="muted">Use o campo <em>fotos_urls</em> com URLs separadas por vírgula.</small>
  </section>
  <section class="card assinaturas">
    <div class="sig">
      <div class="line"><img src="{{assinatura_recebimento}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Recebimento — {{nome_recebimento}} — {{data_recebimento}}</div>
    </div>
    <div class="sig">
      <div class="line"><img src="{{assinatura_qualidade}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Qualidade — {{nome_qualidade}} — {{data_qualidade}}</div>
    </div>
    <div class="sig">
      <div class="line"><img src="{{assinatura_supervisor}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Supervisor — {{nome_supervisor}} — {{data_supervisor}}</div>
    </div>
    <div class="sig">
      <div class="line"><img src="{{assinatura}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Assinatura</div>
    </div>
  </section>
  <section class="card">
    <div class="carimbo">
      <div class="carimbo-inner">
        <strong>{{empresa}}</strong><br>
        CNPJ: {{cnpj}}<br>
        {{endereco}}
      </div>
    </div>
  </section>
  <section class="card grid2">
    <div>
      <h4>Verificação</h4>
      <canvas id="qrcode" width="110" height="110"></canvas>
      <div class="muted">Abra com a câmera para validar</div>
    </div>
    <div>
      <h4>Protocolo</h4>
      <svg id="barcode"></svg>
    </div>
  </section>
</div>
<style>
:root{
  --bg:#ffffff; --fg:#1f2937; --muted:#6b7280; --border:#e5e7eb; --card:#fff; --surface:#f7f8fa;
  --ok:#2e7d32; --warn:#f9a825; --err:#c62828; --brand:#1976d2;
}
[data-theme="dark"], [data-tema="dark"]{
  --bg:#0b1220; --fg:#e5e7eb; --muted:#9ca3af; --border:#344054; --card:#0f172a; --surface:#0d1425;
}
*{box-sizing:border-box}
body{background:var(--surface)}
.sheet{color:var(--fg); background:var(--bg); max-width:900px; margin:0 auto; padding:16px 18px 24px; position:relative}
.print-header,.print-footer{position:sticky; z-index:5; background:var(--bg); color:var(--fg)}
.print-header{top:0; display:flex; align-items:center; justify-content:space-between; border-bottom:1px solid var(--border); padding-bottom:8px; margin-bottom:12px}
.print-header img{height:28px; margin-right:8px}
.print-header .empresa{margin-left:6px; font-weight:600}
.print-header .form-name{margin-left:10px; color:var(--muted)}
.print-footer{bottom:0; display:flex; align-items:center; gap:8px; border-top:1px solid var(--border); padding-top:6px; margin-top:16px; font-size:12px}
.spacer{flex:1}
.no-print{margin:8px 0 12px; display:flex; gap:8px}
.btn{padding:6px 10px; border:1px solid var(--border); background:var(--card); color:var(--fg); border-radius:8px; cursor:pointer}
.btn:hover{background:#eef2f7}
.card{border:1px solid var(--border); background:var(--card); border-radius:12px; padding:12px; margin:10px 0}
.grid2{display:grid; grid-template-columns:1fr 1fr; gap:12px}
@media (max-width:760px){ .grid2{grid-template-columns:1fr} }
label{display:block; font-size:12px; color:var(--muted); margin-bottom:2px}
.val{font-weight:600}
.pre{white-space:pre-wrap}
.tbl{width:100%; border-collapse:collapse}
.tbl th,.tbl td{border:1px solid var(--border); padding:6px}
.tbl .num{text-align:right}
.fotos{display:grid; grid-template-columns:repeat(3,1fr); gap:10px}
.fotos img{width:100%; height:160px; object-fit:cover; border:1px solid var(--border); border-radius:6px}
@media (max-width:900px){ .fotos{grid-template-columns:repeat(2,1fr)} }
@media (max-width:600px){ .fotos{grid-template-columns:1fr} }
.assinaturas{display:grid; grid-template-columns:repeat(2,1fr); gap:14px}
@media (max-width:760px){ .assinaturas{grid-template-columns:1fr} }
.sig .line{height:50px; border-bottom:1px solid var(--fg); display:flex; align-items:center}
.sig img{height:46px; max-width:100%; object-fit:contain}
.sig .legend{font-size:12px; color:var(--muted); margin-top:4px}
.carimbo{display:flex; justify-content:flex-start}
.carimbo-inner{border:2px solid var(--fg); padding:8px 12px; border-radius:8px; display:inline-block}
.stamp{position:absolute; top:90px; right:24px; font-weight:800; padding:6px 10px; border:2px solid currentColor; border-radius:8px; transform:rotate(-8deg)}
.wm{position:fixed; inset:0; display:none; align-items:center; justify-content:center; font:800 90px/1 Inter,system-ui; color:#0002; transform:rotate(-25deg); pointer-events:none; z-index:0}
@media print{
  .no-print{display:none !important}
  .print-header{position:fixed; top:0; left:0; right:0}
  .print-footer{position:fixed; bottom:0; left:0; right:0}
  .sheet{padding-top:70px; padding-bottom:55px}
}
</style>
<script src="https://cdn.jsdelivr.net/npm/qrcode@1.5.3/build/qrcode.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.6/dist/JsBarcode.all.min.js"></script>
<script>
(function(){
  const sheet = document.getElementById(''sheet'');
  const saved = localStorage.getItem(''layout_theme'');
  if(saved) sheet.setAttribute(''data-tema'', saved);
  window.toggleTheme = function(){
    const cur = sheet.getAttribute(''data-tema'') === ''dark'' ? ''light'' : ''dark'';
    sheet.setAttribute(''data-tema'', cur);
    localStorage.setItem(''layout_theme'', cur);
  };
  const statusRaw = (sheet.getAttribute(''data-status'') || '''').toLowerCase().normalize(''NFD'').replace(/\p{Diacritic}/gu,'''');
  const stamp = document.getElementById(''stamp'');
  if (stamp){
    stamp.className = ''stamp'';
    if (statusRaw.includes(''conforme'') && !statusRaw.includes(''nao'')) stamp.style.color = ''#2e7d32'';
    else if (statusRaw.includes(''parcial'')) stamp.style.color = ''#f9a825'';
    else if (statusRaw.includes(''nao'') || statusRaw.includes(''reprov'')) stamp.style.color = ''#c62828'';
  }
  const wm = document.getElementById(''wm'');
  if (wm){
    wm.style.display = (statusRaw.includes(''nao'') || statusRaw.includes(''reprov'')) ? ''flex'' : ''none'';
  }
  try{
    const base = "{{base_url}}".trim() || (location.origin + location.pathname.replace(/\/[^\/]*$/,''''));
    const sid  = "{{submission_id}}".trim() || document.getElementById(''proto'').textContent.trim();
    const veri = "{{veri_hash}}".trim();
    const url  = veri ? `${base}/submission_view.php?id=${encodeURIComponent(sid)}&h=${encodeURIComponent(veri)}`
                      : `${base}/submission_view.php?id=${encodeURIComponent(sid)}`;
    const canvas = document.getElementById(''qrcode'');
    if (canvas && typeof QRCode !== ''undefined'') { QRCode.toCanvas(canvas, url, { width: 110, margin: 1 }); }
  }catch(e){}
  try{
    const proto = document.getElementById(''proto'')?.textContent?.trim() || '''';
    if (proto && typeof JsBarcode !== ''undefined'') { JsBarcode("#barcode", proto, { format:"CODE128", height:32, displayValue:true }); }
  }catch(e){}
  (function(){
    const el = document.getElementById(''fotos'');
    if (!el) return;
    const listRaw = `{{fotos_urls}}`;
    if (!listRaw || listRaw.includes(''{{'')) { el.innerHTML = ''<span class="muted">Sem fotos</span>''; return; }
    const urls = listRaw.split('','').map(s=>s.trim()).filter(Boolean);
    if (!urls.length){ el.innerHTML = ''<span class="muted">Sem fotos</span>''; return; }
    el.innerHTML = urls.map(u => `<img src="${u}" alt="foto" onerror="this.style.display=''none''">`).join('''');
  })();
})();
</script>
', NOW());
INSERT INTO form_versions (form_id, user, note, schema_json, created_at) VALUES (1, 'seed', 'seed', '{"fill_columns": 1, "steps": [{"title": "Dados", "columns": 2, "fields": [{"name": "data", "label": "Data", "type": "date", "required": true}, {"name": "turno", "label": "Turno", "type": "select", "options": ["Manhã", "Tarde", "Noite"], "required": true}, {"name": "responsavel", "label": "Responsável", "type": "text", "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "status", "label": "Status", "type": "select", "options": ["Conforme", "Parcial", "Não conforme", "Fechado"], "required": true, "editable_by": ["qualidade", "supervisor"]}, {"name": "owner_role", "label": "Dono atual (setor)", "type": "select", "options": ["recebimento", "qualidade", "supervisor"], "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "descricao", "label": "Descrição", "type": "textarea", "required": false}, {"name": "anexo", "label": "Anexo", "type": "file", "required": false}, {"name": "assinatura", "label": "Assinatura", "type": "signature", "required": false}]}]}', NOW());
INSERT INTO forms (id, name, slug, category_id, schema_json, html_layout, created_at) VALUES (2, 'Inspeção de Qualidade em Processo', 'inspecao-de-qualidade-em-processo', 2, '{"fill_columns": 1, "steps": [{"title": "Dados", "columns": 2, "fields": [{"name": "data", "label": "Data", "type": "date", "required": true}, {"name": "turno", "label": "Turno", "type": "select", "options": ["Manhã", "Tarde", "Noite"], "required": true}, {"name": "responsavel", "label": "Responsável", "type": "text", "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "status", "label": "Status", "type": "select", "options": ["Conforme", "Parcial", "Não conforme", "Fechado"], "required": true, "editable_by": ["qualidade", "supervisor"]}, {"name": "owner_role", "label": "Dono atual (setor)", "type": "select", "options": ["recebimento", "qualidade", "supervisor"], "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "descricao", "label": "Descrição", "type": "textarea", "required": false}, {"name": "anexo", "label": "Anexo", "type": "file", "required": false}, {"name": "assinatura", "label": "Assinatura", "type": "signature", "required": false}]}]}', '<!— cole tudo no Editor de Layout —>
<div class="sheet" id="sheet" data-status="{{status}}" data-tema="light">
  <header class="print-header">
    <div class="left">
      <img src="{{logo_url}}" alt="logo" onerror="this.style.display=''none''" />
      <span class="empresa">{{empresa}}</span>
      <span class="form-name">{{form_name}}</span>
    </div>
    <div class="right">
      <div><strong>Protocolo:</strong> <span id="proto">{{protocolo}}{{submission_id}}</span></div>
      <div><strong>Data:</strong> {{data}}</div>
    </div>
  </header>
  <footer class="print-footer">
    Gerado por <strong>{{usuario}}</strong> em <strong>{{impresso_em}}</strong>
    <span class="spacer"></span>
    <span class="page-counter">Página <span class="pageNumber"></span> / <span class="totalPages"></span></span>
  </footer>
  <div class="wm" id="wm">NÃO CONFORME</div>
  <div class="stamp" id="stamp">{{status}}</div>
  <div class="actions no-print">
    <button class="btn" onclick="toggleTheme()">Alternar tema</button>
    <button class="btn" onclick="window.print()">Imprimir</button>
  </div>
  <section class="grid2 card">
    <div><label>Responsável</label><div class="val">{{responsavel}}</div></div>
    <div><label>Setor atual</label><div class="val">{{owner_role}}</div></div>
    <div><label>Status</label><div class="val">{{status}}</div></div>
    <div><label>Turno</label><div class="val">{{turno}}</div></div>
  </section>
  <section class="card">
    <h3>Descrição</h3>
    <div class="pre">{{descricao}}</div>
  </section>
  <section class="card">
    <h3>Itens</h3>
    <table class="tbl" id="tbl-itens">
      <thead><tr><th>Item</th><th class="num">Qtde</th><th>Unid</th></tr></thead>
      <tbody>
        {{#each itens}}
          <tr><td>{{descricao}}</td><td class="num">{{qtde}}</td><td>{{un}}</td></tr>
        {{/each}}
      </tbody>
      <tfoot><tr><th>Total</th><th class="num">{{sum itens.qtde}}</th><th></th></tr></tfoot>
    </table>
  </section>
  <section class="card">
    <h3>Fotos</h3>
    <div class="fotos" id="fotos"></div>
    <small class="muted">Use o campo <em>fotos_urls</em> com URLs separadas por vírgula.</small>
  </section>
  <section class="card assinaturas">
    <div class="sig">
      <div class="line"><img src="{{assinatura_recebimento}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Recebimento — {{nome_recebimento}} — {{data_recebimento}}</div>
    </div>
    <div class="sig">
      <div class="line"><img src="{{assinatura_qualidade}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Qualidade — {{nome_qualidade}} — {{data_qualidade}}</div>
    </div>
    <div class="sig">
      <div class="line"><img src="{{assinatura_supervisor}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Supervisor — {{nome_supervisor}} — {{data_supervisor}}</div>
    </div>
    <div class="sig">
      <div class="line"><img src="{{assinatura}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Assinatura</div>
    </div>
  </section>
  <section class="card">
    <div class="carimbo">
      <div class="carimbo-inner">
        <strong>{{empresa}}</strong><br>
        CNPJ: {{cnpj}}<br>
        {{endereco}}
      </div>
    </div>
  </section>
  <section class="card grid2">
    <div>
      <h4>Verificação</h4>
      <canvas id="qrcode" width="110" height="110"></canvas>
      <div class="muted">Abra com a câmera para validar</div>
    </div>
    <div>
      <h4>Protocolo</h4>
      <svg id="barcode"></svg>
    </div>
  </section>
</div>
<style>
:root{
  --bg:#ffffff; --fg:#1f2937; --muted:#6b7280; --border:#e5e7eb; --card:#fff; --surface:#f7f8fa;
  --ok:#2e7d32; --warn:#f9a825; --err:#c62828; --brand:#1976d2;
}
[data-theme="dark"], [data-tema="dark"]{
  --bg:#0b1220; --fg:#e5e7eb; --muted:#9ca3af; --border:#344054; --card:#0f172a; --surface:#0d1425;
}
*{box-sizing:border-box}
body{background:var(--surface)}
.sheet{color:var(--fg); background:var(--bg); max-width:900px; margin:0 auto; padding:16px 18px 24px; position:relative}
.print-header,.print-footer{position:sticky; z-index:5; background:var(--bg); color:var(--fg)}
.print-header{top:0; display:flex; align-items:center; justify-content:space-between; border-bottom:1px solid var(--border); padding-bottom:8px; margin-bottom:12px}
.print-header img{height:28px; margin-right:8px}
.print-header .empresa{margin-left:6px; font-weight:600}
.print-header .form-name{margin-left:10px; color:var(--muted)}
.print-footer{bottom:0; display:flex; align-items:center; gap:8px; border-top:1px solid var(--border); padding-top:6px; margin-top:16px; font-size:12px}
.spacer{flex:1}
.no-print{margin:8px 0 12px; display:flex; gap:8px}
.btn{padding:6px 10px; border:1px solid var(--border); background:var(--card); color:var(--fg); border-radius:8px; cursor:pointer}
.btn:hover{background:#eef2f7}
.card{border:1px solid var(--border); background:var(--card); border-radius:12px; padding:12px; margin:10px 0}
.grid2{display:grid; grid-template-columns:1fr 1fr; gap:12px}
@media (max-width:760px){ .grid2{grid-template-columns:1fr} }
label{display:block; font-size:12px; color:var(--muted); margin-bottom:2px}
.val{font-weight:600}
.pre{white-space:pre-wrap}
.tbl{width:100%; border-collapse:collapse}
.tbl th,.tbl td{border:1px solid var(--border); padding:6px}
.tbl .num{text-align:right}
.fotos{display:grid; grid-template-columns:repeat(3,1fr); gap:10px}
.fotos img{width:100%; height:160px; object-fit:cover; border:1px solid var(--border); border-radius:6px}
@media (max-width:900px){ .fotos{grid-template-columns:repeat(2,1fr)} }
@media (max-width:600px){ .fotos{grid-template-columns:1fr} }
.assinaturas{display:grid; grid-template-columns:repeat(2,1fr); gap:14px}
@media (max-width:760px){ .assinaturas{grid-template-columns:1fr} }
.sig .line{height:50px; border-bottom:1px solid var(--fg); display:flex; align-items:center}
.sig img{height:46px; max-width:100%; object-fit:contain}
.sig .legend{font-size:12px; color:var(--muted); margin-top:4px}
.carimbo{display:flex; justify-content:flex-start}
.carimbo-inner{border:2px solid var(--fg); padding:8px 12px; border-radius:8px; display:inline-block}
.stamp{position:absolute; top:90px; right:24px; font-weight:800; padding:6px 10px; border:2px solid currentColor; border-radius:8px; transform:rotate(-8deg)}
.wm{position:fixed; inset:0; display:none; align-items:center; justify-content:center; font:800 90px/1 Inter,system-ui; color:#0002; transform:rotate(-25deg); pointer-events:none; z-index:0}
@media print{
  .no-print{display:none !important}
  .print-header{position:fixed; top:0; left:0; right:0}
  .print-footer{position:fixed; bottom:0; left:0; right:0}
  .sheet{padding-top:70px; padding-bottom:55px}
}
</style>
<script src="https://cdn.jsdelivr.net/npm/qrcode@1.5.3/build/qrcode.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.6/dist/JsBarcode.all.min.js"></script>
<script>
(function(){
  const sheet = document.getElementById(''sheet'');
  const saved = localStorage.getItem(''layout_theme'');
  if(saved) sheet.setAttribute(''data-tema'', saved);
  window.toggleTheme = function(){
    const cur = sheet.getAttribute(''data-tema'') === ''dark'' ? ''light'' : ''dark'';
    sheet.setAttribute(''data-tema'', cur);
    localStorage.setItem(''layout_theme'', cur);
  };
  const statusRaw = (sheet.getAttribute(''data-status'') || '''').toLowerCase().normalize(''NFD'').replace(/\p{Diacritic}/gu,'''');
  const stamp = document.getElementById(''stamp'');
  if (stamp){
    stamp.className = ''stamp'';
    if (statusRaw.includes(''conforme'') && !statusRaw.includes(''nao'')) stamp.style.color = ''#2e7d32'';
    else if (statusRaw.includes(''parcial'')) stamp.style.color = ''#f9a825'';
    else if (statusRaw.includes(''nao'') || statusRaw.includes(''reprov'')) stamp.style.color = ''#c62828'';
  }
  const wm = document.getElementById(''wm'');
  if (wm){
    wm.style.display = (statusRaw.includes(''nao'') || statusRaw.includes(''reprov'')) ? ''flex'' : ''none'';
  }
  try{
    const base = "{{base_url}}".trim() || (location.origin + location.pathname.replace(/\/[^\/]*$/,''''));
    const sid  = "{{submission_id}}".trim() || document.getElementById(''proto'').textContent.trim();
    const veri = "{{veri_hash}}".trim();
    const url  = veri ? `${base}/submission_view.php?id=${encodeURIComponent(sid)}&h=${encodeURIComponent(veri)}`
                      : `${base}/submission_view.php?id=${encodeURIComponent(sid)}`;
    const canvas = document.getElementById(''qrcode'');
    if (canvas && typeof QRCode !== ''undefined'') { QRCode.toCanvas(canvas, url, { width: 110, margin: 1 }); }
  }catch(e){}
  try{
    const proto = document.getElementById(''proto'')?.textContent?.trim() || '''';
    if (proto && typeof JsBarcode !== ''undefined'') { JsBarcode("#barcode", proto, { format:"CODE128", height:32, displayValue:true }); }
  }catch(e){}
  (function(){
    const el = document.getElementById(''fotos'');
    if (!el) return;
    const listRaw = `{{fotos_urls}}`;
    if (!listRaw || listRaw.includes(''{{'')) { el.innerHTML = ''<span class="muted">Sem fotos</span>''; return; }
    const urls = listRaw.split('','').map(s=>s.trim()).filter(Boolean);
    if (!urls.length){ el.innerHTML = ''<span class="muted">Sem fotos</span>''; return; }
    el.innerHTML = urls.map(u => `<img src="${u}" alt="foto" onerror="this.style.display=''none''">`).join('''');
  })();
})();
</script>
', NOW());
INSERT INTO form_versions (form_id, user, note, schema_json, created_at) VALUES (2, 'seed', 'seed', '{"fill_columns": 1, "steps": [{"title": "Dados", "columns": 2, "fields": [{"name": "data", "label": "Data", "type": "date", "required": true}, {"name": "turno", "label": "Turno", "type": "select", "options": ["Manhã", "Tarde", "Noite"], "required": true}, {"name": "responsavel", "label": "Responsável", "type": "text", "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "status", "label": "Status", "type": "select", "options": ["Conforme", "Parcial", "Não conforme", "Fechado"], "required": true, "editable_by": ["qualidade", "supervisor"]}, {"name": "owner_role", "label": "Dono atual (setor)", "type": "select", "options": ["recebimento", "qualidade", "supervisor"], "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "descricao", "label": "Descrição", "type": "textarea", "required": false}, {"name": "anexo", "label": "Anexo", "type": "file", "required": false}, {"name": "assinatura", "label": "Assinatura", "type": "signature", "required": false}]}]}', NOW());
INSERT INTO forms (id, name, slug, category_id, schema_json, html_layout, created_at) VALUES (3, 'Liberação de Lote', 'liberacao-de-lote', 2, '{"fill_columns": 1, "steps": [{"title": "Dados", "columns": 2, "fields": [{"name": "data", "label": "Data", "type": "date", "required": true}, {"name": "turno", "label": "Turno", "type": "select", "options": ["Manhã", "Tarde", "Noite"], "required": true}, {"name": "responsavel", "label": "Responsável", "type": "text", "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "status", "label": "Status", "type": "select", "options": ["Conforme", "Parcial", "Não conforme", "Fechado"], "required": true, "editable_by": ["qualidade", "supervisor"]}, {"name": "owner_role", "label": "Dono atual (setor)", "type": "select", "options": ["recebimento", "qualidade", "supervisor"], "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "descricao", "label": "Descrição", "type": "textarea", "required": false}, {"name": "anexo", "label": "Anexo", "type": "file", "required": false}, {"name": "assinatura", "label": "Assinatura", "type": "signature", "required": false}]}]}', '<!— cole tudo no Editor de Layout —>
<div class="sheet" id="sheet" data-status="{{status}}" data-tema="light">
  <header class="print-header">
    <div class="left">
      <img src="{{logo_url}}" alt="logo" onerror="this.style.display=''none''" />
      <span class="empresa">{{empresa}}</span>
      <span class="form-name">{{form_name}}</span>
    </div>
    <div class="right">
      <div><strong>Protocolo:</strong> <span id="proto">{{protocolo}}{{submission_id}}</span></div>
      <div><strong>Data:</strong> {{data}}</div>
    </div>
  </header>
  <footer class="print-footer">
    Gerado por <strong>{{usuario}}</strong> em <strong>{{impresso_em}}</strong>
    <span class="spacer"></span>
    <span class="page-counter">Página <span class="pageNumber"></span> / <span class="totalPages"></span></span>
  </footer>
  <div class="wm" id="wm">NÃO CONFORME</div>
  <div class="stamp" id="stamp">{{status}}</div>
  <div class="actions no-print">
    <button class="btn" onclick="toggleTheme()">Alternar tema</button>
    <button class="btn" onclick="window.print()">Imprimir</button>
  </div>
  <section class="grid2 card">
    <div><label>Responsável</label><div class="val">{{responsavel}}</div></div>
    <div><label>Setor atual</label><div class="val">{{owner_role}}</div></div>
    <div><label>Status</label><div class="val">{{status}}</div></div>
    <div><label>Turno</label><div class="val">{{turno}}</div></div>
  </section>
  <section class="card">
    <h3>Descrição</h3>
    <div class="pre">{{descricao}}</div>
  </section>
  <section class="card">
    <h3>Itens</h3>
    <table class="tbl" id="tbl-itens">
      <thead><tr><th>Item</th><th class="num">Qtde</th><th>Unid</th></tr></thead>
      <tbody>
        {{#each itens}}
          <tr><td>{{descricao}}</td><td class="num">{{qtde}}</td><td>{{un}}</td></tr>
        {{/each}}
      </tbody>
      <tfoot><tr><th>Total</th><th class="num">{{sum itens.qtde}}</th><th></th></tr></tfoot>
    </table>
  </section>
  <section class="card">
    <h3>Fotos</h3>
    <div class="fotos" id="fotos"></div>
    <small class="muted">Use o campo <em>fotos_urls</em> com URLs separadas por vírgula.</small>
  </section>
  <section class="card assinaturas">
    <div class="sig">
      <div class="line"><img src="{{assinatura_recebimento}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Recebimento — {{nome_recebimento}} — {{data_recebimento}}</div>
    </div>
    <div class="sig">
      <div class="line"><img src="{{assinatura_qualidade}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Qualidade — {{nome_qualidade}} — {{data_qualidade}}</div>
    </div>
    <div class="sig">
      <div class="line"><img src="{{assinatura_supervisor}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Supervisor — {{nome_supervisor}} — {{data_supervisor}}</div>
    </div>
    <div class="sig">
      <div class="line"><img src="{{assinatura}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Assinatura</div>
    </div>
  </section>
  <section class="card">
    <div class="carimbo">
      <div class="carimbo-inner">
        <strong>{{empresa}}</strong><br>
        CNPJ: {{cnpj}}<br>
        {{endereco}}
      </div>
    </div>
  </section>
  <section class="card grid2">
    <div>
      <h4>Verificação</h4>
      <canvas id="qrcode" width="110" height="110"></canvas>
      <div class="muted">Abra com a câmera para validar</div>
    </div>
    <div>
      <h4>Protocolo</h4>
      <svg id="barcode"></svg>
    </div>
  </section>
</div>
<style>
:root{
  --bg:#ffffff; --fg:#1f2937; --muted:#6b7280; --border:#e5e7eb; --card:#fff; --surface:#f7f8fa;
  --ok:#2e7d32; --warn:#f9a825; --err:#c62828; --brand:#1976d2;
}
[data-theme="dark"], [data-tema="dark"]{
  --bg:#0b1220; --fg:#e5e7eb; --muted:#9ca3af; --border:#344054; --card:#0f172a; --surface:#0d1425;
}
*{box-sizing:border-box}
body{background:var(--surface)}
.sheet{color:var(--fg); background:var(--bg); max-width:900px; margin:0 auto; padding:16px 18px 24px; position:relative}
.print-header,.print-footer{position:sticky; z-index:5; background:var(--bg); color:var(--fg)}
.print-header{top:0; display:flex; align-items:center; justify-content:space-between; border-bottom:1px solid var(--border); padding-bottom:8px; margin-bottom:12px}
.print-header img{height:28px; margin-right:8px}
.print-header .empresa{margin-left:6px; font-weight:600}
.print-header .form-name{margin-left:10px; color:var(--muted)}
.print-footer{bottom:0; display:flex; align-items:center; gap:8px; border-top:1px solid var(--border); padding-top:6px; margin-top:16px; font-size:12px}
.spacer{flex:1}
.no-print{margin:8px 0 12px; display:flex; gap:8px}
.btn{padding:6px 10px; border:1px solid var(--border); background:var(--card); color:var(--fg); border-radius:8px; cursor:pointer}
.btn:hover{background:#eef2f7}
.card{border:1px solid var(--border); background:var(--card); border-radius:12px; padding:12px; margin:10px 0}
.grid2{display:grid; grid-template-columns:1fr 1fr; gap:12px}
@media (max-width:760px){ .grid2{grid-template-columns:1fr} }
label{display:block; font-size:12px; color:var(--muted); margin-bottom:2px}
.val{font-weight:600}
.pre{white-space:pre-wrap}
.tbl{width:100%; border-collapse:collapse}
.tbl th,.tbl td{border:1px solid var(--border); padding:6px}
.tbl .num{text-align:right}
.fotos{display:grid; grid-template-columns:repeat(3,1fr); gap:10px}
.fotos img{width:100%; height:160px; object-fit:cover; border:1px solid var(--border); border-radius:6px}
@media (max-width:900px){ .fotos{grid-template-columns:repeat(2,1fr)} }
@media (max-width:600px){ .fotos{grid-template-columns:1fr} }
.assinaturas{display:grid; grid-template-columns:repeat(2,1fr); gap:14px}
@media (max-width:760px){ .assinaturas{grid-template-columns:1fr} }
.sig .line{height:50px; border-bottom:1px solid var(--fg); display:flex; align-items:center}
.sig img{height:46px; max-width:100%; object-fit:contain}
.sig .legend{font-size:12px; color:var(--muted); margin-top:4px}
.carimbo{display:flex; justify-content:flex-start}
.carimbo-inner{border:2px solid var(--fg); padding:8px 12px; border-radius:8px; display:inline-block}
.stamp{position:absolute; top:90px; right:24px; font-weight:800; padding:6px 10px; border:2px solid currentColor; border-radius:8px; transform:rotate(-8deg)}
.wm{position:fixed; inset:0; display:none; align-items:center; justify-content:center; font:800 90px/1 Inter,system-ui; color:#0002; transform:rotate(-25deg); pointer-events:none; z-index:0}
@media print{
  .no-print{display:none !important}
  .print-header{position:fixed; top:0; left:0; right:0}
  .print-footer{position:fixed; bottom:0; left:0; right:0}
  .sheet{padding-top:70px; padding-bottom:55px}
}
</style>
<script src="https://cdn.jsdelivr.net/npm/qrcode@1.5.3/build/qrcode.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.6/dist/JsBarcode.all.min.js"></script>
<script>
(function(){
  const sheet = document.getElementById(''sheet'');
  const saved = localStorage.getItem(''layout_theme'');
  if(saved) sheet.setAttribute(''data-tema'', saved);
  window.toggleTheme = function(){
    const cur = sheet.getAttribute(''data-tema'') === ''dark'' ? ''light'' : ''dark'';
    sheet.setAttribute(''data-tema'', cur);
    localStorage.setItem(''layout_theme'', cur);
  };
  const statusRaw = (sheet.getAttribute(''data-status'') || '''').toLowerCase().normalize(''NFD'').replace(/\p{Diacritic}/gu,'''');
  const stamp = document.getElementById(''stamp'');
  if (stamp){
    stamp.className = ''stamp'';
    if (statusRaw.includes(''conforme'') && !statusRaw.includes(''nao'')) stamp.style.color = ''#2e7d32'';
    else if (statusRaw.includes(''parcial'')) stamp.style.color = ''#f9a825'';
    else if (statusRaw.includes(''nao'') || statusRaw.includes(''reprov'')) stamp.style.color = ''#c62828'';
  }
  const wm = document.getElementById(''wm'');
  if (wm){
    wm.style.display = (statusRaw.includes(''nao'') || statusRaw.includes(''reprov'')) ? ''flex'' : ''none'';
  }
  try{
    const base = "{{base_url}}".trim() || (location.origin + location.pathname.replace(/\/[^\/]*$/,''''));
    const sid  = "{{submission_id}}".trim() || document.getElementById(''proto'').textContent.trim();
    const veri = "{{veri_hash}}".trim();
    const url  = veri ? `${base}/submission_view.php?id=${encodeURIComponent(sid)}&h=${encodeURIComponent(veri)}`
                      : `${base}/submission_view.php?id=${encodeURIComponent(sid)}`;
    const canvas = document.getElementById(''qrcode'');
    if (canvas && typeof QRCode !== ''undefined'') { QRCode.toCanvas(canvas, url, { width: 110, margin: 1 }); }
  }catch(e){}
  try{
    const proto = document.getElementById(''proto'')?.textContent?.trim() || '''';
    if (proto && typeof JsBarcode !== ''undefined'') { JsBarcode("#barcode", proto, { format:"CODE128", height:32, displayValue:true }); }
  }catch(e){}
  (function(){
    const el = document.getElementById(''fotos'');
    if (!el) return;
    const listRaw = `{{fotos_urls}}`;
    if (!listRaw || listRaw.includes(''{{'')) { el.innerHTML = ''<span class="muted">Sem fotos</span>''; return; }
    const urls = listRaw.split('','').map(s=>s.trim()).filter(Boolean);
    if (!urls.length){ el.innerHTML = ''<span class="muted">Sem fotos</span>''; return; }
    el.innerHTML = urls.map(u => `<img src="${u}" alt="foto" onerror="this.style.display=''none''">`).join('''');
  })();
})();
</script>
', NOW());
INSERT INTO form_versions (form_id, user, note, schema_json, created_at) VALUES (3, 'seed', 'seed', '{"fill_columns": 1, "steps": [{"title": "Dados", "columns": 2, "fields": [{"name": "data", "label": "Data", "type": "date", "required": true}, {"name": "turno", "label": "Turno", "type": "select", "options": ["Manhã", "Tarde", "Noite"], "required": true}, {"name": "responsavel", "label": "Responsável", "type": "text", "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "status", "label": "Status", "type": "select", "options": ["Conforme", "Parcial", "Não conforme", "Fechado"], "required": true, "editable_by": ["qualidade", "supervisor"]}, {"name": "owner_role", "label": "Dono atual (setor)", "type": "select", "options": ["recebimento", "qualidade", "supervisor"], "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "descricao", "label": "Descrição", "type": "textarea", "required": false}, {"name": "anexo", "label": "Anexo", "type": "file", "required": false}, {"name": "assinatura", "label": "Assinatura", "type": "signature", "required": false}]}]}', NOW());
INSERT INTO forms (id, name, slug, category_id, schema_json, html_layout, created_at) VALUES (4, 'Registro de Não Conformidade', 'registro-de-nao-conformidade', 2, '{"fill_columns": 1, "steps": [{"title": "Dados", "columns": 2, "fields": [{"name": "data", "label": "Data", "type": "date", "required": true}, {"name": "turno", "label": "Turno", "type": "select", "options": ["Manhã", "Tarde", "Noite"], "required": true}, {"name": "responsavel", "label": "Responsável", "type": "text", "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "status", "label": "Status", "type": "select", "options": ["Conforme", "Parcial", "Não conforme", "Fechado"], "required": true, "editable_by": ["qualidade", "supervisor"]}, {"name": "owner_role", "label": "Dono atual (setor)", "type": "select", "options": ["recebimento", "qualidade", "supervisor"], "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "descricao", "label": "Descrição", "type": "textarea", "required": false}, {"name": "anexo", "label": "Anexo", "type": "file", "required": false}, {"name": "assinatura", "label": "Assinatura", "type": "signature", "required": false}]}]}', '<!— cole tudo no Editor de Layout —>
<div class="sheet" id="sheet" data-status="{{status}}" data-tema="light">
  <header class="print-header">
    <div class="left">
      <img src="{{logo_url}}" alt="logo" onerror="this.style.display=''none''" />
      <span class="empresa">{{empresa}}</span>
      <span class="form-name">{{form_name}}</span>
    </div>
    <div class="right">
      <div><strong>Protocolo:</strong> <span id="proto">{{protocolo}}{{submission_id}}</span></div>
      <div><strong>Data:</strong> {{data}}</div>
    </div>
  </header>
  <footer class="print-footer">
    Gerado por <strong>{{usuario}}</strong> em <strong>{{impresso_em}}</strong>
    <span class="spacer"></span>
    <span class="page-counter">Página <span class="pageNumber"></span> / <span class="totalPages"></span></span>
  </footer>
  <div class="wm" id="wm">NÃO CONFORME</div>
  <div class="stamp" id="stamp">{{status}}</div>
  <div class="actions no-print">
    <button class="btn" onclick="toggleTheme()">Alternar tema</button>
    <button class="btn" onclick="window.print()">Imprimir</button>
  </div>
  <section class="grid2 card">
    <div><label>Responsável</label><div class="val">{{responsavel}}</div></div>
    <div><label>Setor atual</label><div class="val">{{owner_role}}</div></div>
    <div><label>Status</label><div class="val">{{status}}</div></div>
    <div><label>Turno</label><div class="val">{{turno}}</div></div>
  </section>
  <section class="card">
    <h3>Descrição</h3>
    <div class="pre">{{descricao}}</div>
  </section>
  <section class="card">
    <h3>Itens</h3>
    <table class="tbl" id="tbl-itens">
      <thead><tr><th>Item</th><th class="num">Qtde</th><th>Unid</th></tr></thead>
      <tbody>
        {{#each itens}}
          <tr><td>{{descricao}}</td><td class="num">{{qtde}}</td><td>{{un}}</td></tr>
        {{/each}}
      </tbody>
      <tfoot><tr><th>Total</th><th class="num">{{sum itens.qtde}}</th><th></th></tr></tfoot>
    </table>
  </section>
  <section class="card">
    <h3>Fotos</h3>
    <div class="fotos" id="fotos"></div>
    <small class="muted">Use o campo <em>fotos_urls</em> com URLs separadas por vírgula.</small>
  </section>
  <section class="card assinaturas">
    <div class="sig">
      <div class="line"><img src="{{assinatura_recebimento}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Recebimento — {{nome_recebimento}} — {{data_recebimento}}</div>
    </div>
    <div class="sig">
      <div class="line"><img src="{{assinatura_qualidade}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Qualidade — {{nome_qualidade}} — {{data_qualidade}}</div>
    </div>
    <div class="sig">
      <div class="line"><img src="{{assinatura_supervisor}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Supervisor — {{nome_supervisor}} — {{data_supervisor}}</div>
    </div>
    <div class="sig">
      <div class="line"><img src="{{assinatura}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Assinatura</div>
    </div>
  </section>
  <section class="card">
    <div class="carimbo">
      <div class="carimbo-inner">
        <strong>{{empresa}}</strong><br>
        CNPJ: {{cnpj}}<br>
        {{endereco}}
      </div>
    </div>
  </section>
  <section class="card grid2">
    <div>
      <h4>Verificação</h4>
      <canvas id="qrcode" width="110" height="110"></canvas>
      <div class="muted">Abra com a câmera para validar</div>
    </div>
    <div>
      <h4>Protocolo</h4>
      <svg id="barcode"></svg>
    </div>
  </section>
</div>
<style>
:root{
  --bg:#ffffff; --fg:#1f2937; --muted:#6b7280; --border:#e5e7eb; --card:#fff; --surface:#f7f8fa;
  --ok:#2e7d32; --warn:#f9a825; --err:#c62828; --brand:#1976d2;
}
[data-theme="dark"], [data-tema="dark"]{
  --bg:#0b1220; --fg:#e5e7eb; --muted:#9ca3af; --border:#344054; --card:#0f172a; --surface:#0d1425;
}
*{box-sizing:border-box}
body{background:var(--surface)}
.sheet{color:var(--fg); background:var(--bg); max-width:900px; margin:0 auto; padding:16px 18px 24px; position:relative}
.print-header,.print-footer{position:sticky; z-index:5; background:var(--bg); color:var(--fg)}
.print-header{top:0; display:flex; align-items:center; justify-content:space-between; border-bottom:1px solid var(--border); padding-bottom:8px; margin-bottom:12px}
.print-header img{height:28px; margin-right:8px}
.print-header .empresa{margin-left:6px; font-weight:600}
.print-header .form-name{margin-left:10px; color:var(--muted)}
.print-footer{bottom:0; display:flex; align-items:center; gap:8px; border-top:1px solid var(--border); padding-top:6px; margin-top:16px; font-size:12px}
.spacer{flex:1}
.no-print{margin:8px 0 12px; display:flex; gap:8px}
.btn{padding:6px 10px; border:1px solid var(--border); background:var(--card); color:var(--fg); border-radius:8px; cursor:pointer}
.btn:hover{background:#eef2f7}
.card{border:1px solid var(--border); background:var(--card); border-radius:12px; padding:12px; margin:10px 0}
.grid2{display:grid; grid-template-columns:1fr 1fr; gap:12px}
@media (max-width:760px){ .grid2{grid-template-columns:1fr} }
label{display:block; font-size:12px; color:var(--muted); margin-bottom:2px}
.val{font-weight:600}
.pre{white-space:pre-wrap}
.tbl{width:100%; border-collapse:collapse}
.tbl th,.tbl td{border:1px solid var(--border); padding:6px}
.tbl .num{text-align:right}
.fotos{display:grid; grid-template-columns:repeat(3,1fr); gap:10px}
.fotos img{width:100%; height:160px; object-fit:cover; border:1px solid var(--border); border-radius:6px}
@media (max-width:900px){ .fotos{grid-template-columns:repeat(2,1fr)} }
@media (max-width:600px){ .fotos{grid-template-columns:1fr} }
.assinaturas{display:grid; grid-template-columns:repeat(2,1fr); gap:14px}
@media (max-width:760px){ .assinaturas{grid-template-columns:1fr} }
.sig .line{height:50px; border-bottom:1px solid var(--fg); display:flex; align-items:center}
.sig img{height:46px; max-width:100%; object-fit:contain}
.sig .legend{font-size:12px; color:var(--muted); margin-top:4px}
.carimbo{display:flex; justify-content:flex-start}
.carimbo-inner{border:2px solid var(--fg); padding:8px 12px; border-radius:8px; display:inline-block}
.stamp{position:absolute; top:90px; right:24px; font-weight:800; padding:6px 10px; border:2px solid currentColor; border-radius:8px; transform:rotate(-8deg)}
.wm{position:fixed; inset:0; display:none; align-items:center; justify-content:center; font:800 90px/1 Inter,system-ui; color:#0002; transform:rotate(-25deg); pointer-events:none; z-index:0}
@media print{
  .no-print{display:none !important}
  .print-header{position:fixed; top:0; left:0; right:0}
  .print-footer{position:fixed; bottom:0; left:0; right:0}
  .sheet{padding-top:70px; padding-bottom:55px}
}
</style>
<script src="https://cdn.jsdelivr.net/npm/qrcode@1.5.3/build/qrcode.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.6/dist/JsBarcode.all.min.js"></script>
<script>
(function(){
  const sheet = document.getElementById(''sheet'');
  const saved = localStorage.getItem(''layout_theme'');
  if(saved) sheet.setAttribute(''data-tema'', saved);
  window.toggleTheme = function(){
    const cur = sheet.getAttribute(''data-tema'') === ''dark'' ? ''light'' : ''dark'';
    sheet.setAttribute(''data-tema'', cur);
    localStorage.setItem(''layout_theme'', cur);
  };
  const statusRaw = (sheet.getAttribute(''data-status'') || '''').toLowerCase().normalize(''NFD'').replace(/\p{Diacritic}/gu,'''');
  const stamp = document.getElementById(''stamp'');
  if (stamp){
    stamp.className = ''stamp'';
    if (statusRaw.includes(''conforme'') && !statusRaw.includes(''nao'')) stamp.style.color = ''#2e7d32'';
    else if (statusRaw.includes(''parcial'')) stamp.style.color = ''#f9a825'';
    else if (statusRaw.includes(''nao'') || statusRaw.includes(''reprov'')) stamp.style.color = ''#c62828'';
  }
  const wm = document.getElementById(''wm'');
  if (wm){
    wm.style.display = (statusRaw.includes(''nao'') || statusRaw.includes(''reprov'')) ? ''flex'' : ''none'';
  }
  try{
    const base = "{{base_url}}".trim() || (location.origin + location.pathname.replace(/\/[^\/]*$/,''''));
    const sid  = "{{submission_id}}".trim() || document.getElementById(''proto'').textContent.trim();
    const veri = "{{veri_hash}}".trim();
    const url  = veri ? `${base}/submission_view.php?id=${encodeURIComponent(sid)}&h=${encodeURIComponent(veri)}`
                      : `${base}/submission_view.php?id=${encodeURIComponent(sid)}`;
    const canvas = document.getElementById(''qrcode'');
    if (canvas && typeof QRCode !== ''undefined'') { QRCode.toCanvas(canvas, url, { width: 110, margin: 1 }); }
  }catch(e){}
  try{
    const proto = document.getElementById(''proto'')?.textContent?.trim() || '''';
    if (proto && typeof JsBarcode !== ''undefined'') { JsBarcode("#barcode", proto, { format:"CODE128", height:32, displayValue:true }); }
  }catch(e){}
  (function(){
    const el = document.getElementById(''fotos'');
    if (!el) return;
    const listRaw = `{{fotos_urls}}`;
    if (!listRaw || listRaw.includes(''{{'')) { el.innerHTML = ''<span class="muted">Sem fotos</span>''; return; }
    const urls = listRaw.split('','').map(s=>s.trim()).filter(Boolean);
    if (!urls.length){ el.innerHTML = ''<span class="muted">Sem fotos</span>''; return; }
    el.innerHTML = urls.map(u => `<img src="${u}" alt="foto" onerror="this.style.display=''none''">`).join('''');
  })();
})();
</script>
', NOW());
INSERT INTO form_versions (form_id, user, note, schema_json, created_at) VALUES (4, 'seed', 'seed', '{"fill_columns": 1, "steps": [{"title": "Dados", "columns": 2, "fields": [{"name": "data", "label": "Data", "type": "date", "required": true}, {"name": "turno", "label": "Turno", "type": "select", "options": ["Manhã", "Tarde", "Noite"], "required": true}, {"name": "responsavel", "label": "Responsável", "type": "text", "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "status", "label": "Status", "type": "select", "options": ["Conforme", "Parcial", "Não conforme", "Fechado"], "required": true, "editable_by": ["qualidade", "supervisor"]}, {"name": "owner_role", "label": "Dono atual (setor)", "type": "select", "options": ["recebimento", "qualidade", "supervisor"], "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "descricao", "label": "Descrição", "type": "textarea", "required": false}, {"name": "anexo", "label": "Anexo", "type": "file", "required": false}, {"name": "assinatura", "label": "Assinatura", "type": "signature", "required": false}]}]}', NOW());
INSERT INTO forms (id, name, slug, category_id, schema_json, html_layout, created_at) VALUES (5, 'Rastreabilidade de Matéria-prima', 'rastreabilidade-de-materia-prima', 3, '{"fill_columns": 1, "steps": [{"title": "Dados", "columns": 2, "fields": [{"name": "data", "label": "Data", "type": "date", "required": true}, {"name": "turno", "label": "Turno", "type": "select", "options": ["Manhã", "Tarde", "Noite"], "required": true}, {"name": "responsavel", "label": "Responsável", "type": "text", "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "status", "label": "Status", "type": "select", "options": ["Conforme", "Parcial", "Não conforme", "Fechado"], "required": true, "editable_by": ["qualidade", "supervisor"]}, {"name": "owner_role", "label": "Dono atual (setor)", "type": "select", "options": ["recebimento", "qualidade", "supervisor"], "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "descricao", "label": "Descrição", "type": "textarea", "required": false}, {"name": "anexo", "label": "Anexo", "type": "file", "required": false}, {"name": "assinatura", "label": "Assinatura", "type": "signature", "required": false}]}]}', '<!— cole tudo no Editor de Layout —>
<div class="sheet" id="sheet" data-status="{{status}}" data-tema="light">
  <header class="print-header">
    <div class="left">
      <img src="{{logo_url}}" alt="logo" onerror="this.style.display=''none''" />
      <span class="empresa">{{empresa}}</span>
      <span class="form-name">{{form_name}}</span>
    </div>
    <div class="right">
      <div><strong>Protocolo:</strong> <span id="proto">{{protocolo}}{{submission_id}}</span></div>
      <div><strong>Data:</strong> {{data}}</div>
    </div>
  </header>
  <footer class="print-footer">
    Gerado por <strong>{{usuario}}</strong> em <strong>{{impresso_em}}</strong>
    <span class="spacer"></span>
    <span class="page-counter">Página <span class="pageNumber"></span> / <span class="totalPages"></span></span>
  </footer>
  <div class="wm" id="wm">NÃO CONFORME</div>
  <div class="stamp" id="stamp">{{status}}</div>
  <div class="actions no-print">
    <button class="btn" onclick="toggleTheme()">Alternar tema</button>
    <button class="btn" onclick="window.print()">Imprimir</button>
  </div>
  <section class="grid2 card">
    <div><label>Responsável</label><div class="val">{{responsavel}}</div></div>
    <div><label>Setor atual</label><div class="val">{{owner_role}}</div></div>
    <div><label>Status</label><div class="val">{{status}}</div></div>
    <div><label>Turno</label><div class="val">{{turno}}</div></div>
  </section>
  <section class="card">
    <h3>Descrição</h3>
    <div class="pre">{{descricao}}</div>
  </section>
  <section class="card">
    <h3>Itens</h3>
    <table class="tbl" id="tbl-itens">
      <thead><tr><th>Item</th><th class="num">Qtde</th><th>Unid</th></tr></thead>
      <tbody>
        {{#each itens}}
          <tr><td>{{descricao}}</td><td class="num">{{qtde}}</td><td>{{un}}</td></tr>
        {{/each}}
      </tbody>
      <tfoot><tr><th>Total</th><th class="num">{{sum itens.qtde}}</th><th></th></tr></tfoot>
    </table>
  </section>
  <section class="card">
    <h3>Fotos</h3>
    <div class="fotos" id="fotos"></div>
    <small class="muted">Use o campo <em>fotos_urls</em> com URLs separadas por vírgula.</small>
  </section>
  <section class="card assinaturas">
    <div class="sig">
      <div class="line"><img src="{{assinatura_recebimento}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Recebimento — {{nome_recebimento}} — {{data_recebimento}}</div>
    </div>
    <div class="sig">
      <div class="line"><img src="{{assinatura_qualidade}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Qualidade — {{nome_qualidade}} — {{data_qualidade}}</div>
    </div>
    <div class="sig">
      <div class="line"><img src="{{assinatura_supervisor}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Supervisor — {{nome_supervisor}} — {{data_supervisor}}</div>
    </div>
    <div class="sig">
      <div class="line"><img src="{{assinatura}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Assinatura</div>
    </div>
  </section>
  <section class="card">
    <div class="carimbo">
      <div class="carimbo-inner">
        <strong>{{empresa}}</strong><br>
        CNPJ: {{cnpj}}<br>
        {{endereco}}
      </div>
    </div>
  </section>
  <section class="card grid2">
    <div>
      <h4>Verificação</h4>
      <canvas id="qrcode" width="110" height="110"></canvas>
      <div class="muted">Abra com a câmera para validar</div>
    </div>
    <div>
      <h4>Protocolo</h4>
      <svg id="barcode"></svg>
    </div>
  </section>
</div>
<style>
:root{
  --bg:#ffffff; --fg:#1f2937; --muted:#6b7280; --border:#e5e7eb; --card:#fff; --surface:#f7f8fa;
  --ok:#2e7d32; --warn:#f9a825; --err:#c62828; --brand:#1976d2;
}
[data-theme="dark"], [data-tema="dark"]{
  --bg:#0b1220; --fg:#e5e7eb; --muted:#9ca3af; --border:#344054; --card:#0f172a; --surface:#0d1425;
}
*{box-sizing:border-box}
body{background:var(--surface)}
.sheet{color:var(--fg); background:var(--bg); max-width:900px; margin:0 auto; padding:16px 18px 24px; position:relative}
.print-header,.print-footer{position:sticky; z-index:5; background:var(--bg); color:var(--fg)}
.print-header{top:0; display:flex; align-items:center; justify-content:space-between; border-bottom:1px solid var(--border); padding-bottom:8px; margin-bottom:12px}
.print-header img{height:28px; margin-right:8px}
.print-header .empresa{margin-left:6px; font-weight:600}
.print-header .form-name{margin-left:10px; color:var(--muted)}
.print-footer{bottom:0; display:flex; align-items:center; gap:8px; border-top:1px solid var(--border); padding-top:6px; margin-top:16px; font-size:12px}
.spacer{flex:1}
.no-print{margin:8px 0 12px; display:flex; gap:8px}
.btn{padding:6px 10px; border:1px solid var(--border); background:var(--card); color:var(--fg); border-radius:8px; cursor:pointer}
.btn:hover{background:#eef2f7}
.card{border:1px solid var(--border); background:var(--card); border-radius:12px; padding:12px; margin:10px 0}
.grid2{display:grid; grid-template-columns:1fr 1fr; gap:12px}
@media (max-width:760px){ .grid2{grid-template-columns:1fr} }
label{display:block; font-size:12px; color:var(--muted); margin-bottom:2px}
.val{font-weight:600}
.pre{white-space:pre-wrap}
.tbl{width:100%; border-collapse:collapse}
.tbl th,.tbl td{border:1px solid var(--border); padding:6px}
.tbl .num{text-align:right}
.fotos{display:grid; grid-template-columns:repeat(3,1fr); gap:10px}
.fotos img{width:100%; height:160px; object-fit:cover; border:1px solid var(--border); border-radius:6px}
@media (max-width:900px){ .fotos{grid-template-columns:repeat(2,1fr)} }
@media (max-width:600px){ .fotos{grid-template-columns:1fr} }
.assinaturas{display:grid; grid-template-columns:repeat(2,1fr); gap:14px}
@media (max-width:760px){ .assinaturas{grid-template-columns:1fr} }
.sig .line{height:50px; border-bottom:1px solid var(--fg); display:flex; align-items:center}
.sig img{height:46px; max-width:100%; object-fit:contain}
.sig .legend{font-size:12px; color:var(--muted); margin-top:4px}
.carimbo{display:flex; justify-content:flex-start}
.carimbo-inner{border:2px solid var(--fg); padding:8px 12px; border-radius:8px; display:inline-block}
.stamp{position:absolute; top:90px; right:24px; font-weight:800; padding:6px 10px; border:2px solid currentColor; border-radius:8px; transform:rotate(-8deg)}
.wm{position:fixed; inset:0; display:none; align-items:center; justify-content:center; font:800 90px/1 Inter,system-ui; color:#0002; transform:rotate(-25deg); pointer-events:none; z-index:0}
@media print{
  .no-print{display:none !important}
  .print-header{position:fixed; top:0; left:0; right:0}
  .print-footer{position:fixed; bottom:0; left:0; right:0}
  .sheet{padding-top:70px; padding-bottom:55px}
}
</style>
<script src="https://cdn.jsdelivr.net/npm/qrcode@1.5.3/build/qrcode.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.6/dist/JsBarcode.all.min.js"></script>
<script>
(function(){
  const sheet = document.getElementById(''sheet'');
  const saved = localStorage.getItem(''layout_theme'');
  if(saved) sheet.setAttribute(''data-tema'', saved);
  window.toggleTheme = function(){
    const cur = sheet.getAttribute(''data-tema'') === ''dark'' ? ''light'' : ''dark'';
    sheet.setAttribute(''data-tema'', cur);
    localStorage.setItem(''layout_theme'', cur);
  };
  const statusRaw = (sheet.getAttribute(''data-status'') || '''').toLowerCase().normalize(''NFD'').replace(/\p{Diacritic}/gu,'''');
  const stamp = document.getElementById(''stamp'');
  if (stamp){
    stamp.className = ''stamp'';
    if (statusRaw.includes(''conforme'') && !statusRaw.includes(''nao'')) stamp.style.color = ''#2e7d32'';
    else if (statusRaw.includes(''parcial'')) stamp.style.color = ''#f9a825'';
    else if (statusRaw.includes(''nao'') || statusRaw.includes(''reprov'')) stamp.style.color = ''#c62828'';
  }
  const wm = document.getElementById(''wm'');
  if (wm){
    wm.style.display = (statusRaw.includes(''nao'') || statusRaw.includes(''reprov'')) ? ''flex'' : ''none'';
  }
  try{
    const base = "{{base_url}}".trim() || (location.origin + location.pathname.replace(/\/[^\/]*$/,''''));
    const sid  = "{{submission_id}}".trim() || document.getElementById(''proto'').textContent.trim();
    const veri = "{{veri_hash}}".trim();
    const url  = veri ? `${base}/submission_view.php?id=${encodeURIComponent(sid)}&h=${encodeURIComponent(veri)}`
                      : `${base}/submission_view.php?id=${encodeURIComponent(sid)}`;
    const canvas = document.getElementById(''qrcode'');
    if (canvas && typeof QRCode !== ''undefined'') { QRCode.toCanvas(canvas, url, { width: 110, margin: 1 }); }
  }catch(e){}
  try{
    const proto = document.getElementById(''proto'')?.textContent?.trim() || '''';
    if (proto && typeof JsBarcode !== ''undefined'') { JsBarcode("#barcode", proto, { format:"CODE128", height:32, displayValue:true }); }
  }catch(e){}
  (function(){
    const el = document.getElementById(''fotos'');
    if (!el) return;
    const listRaw = `{{fotos_urls}}`;
    if (!listRaw || listRaw.includes(''{{'')) { el.innerHTML = ''<span class="muted">Sem fotos</span>''; return; }
    const urls = listRaw.split('','').map(s=>s.trim()).filter(Boolean);
    if (!urls.length){ el.innerHTML = ''<span class="muted">Sem fotos</span>''; return; }
    el.innerHTML = urls.map(u => `<img src="${u}" alt="foto" onerror="this.style.display=''none''">`).join('''');
  })();
})();
</script>
', NOW());
INSERT INTO form_versions (form_id, user, note, schema_json, created_at) VALUES (5, 'seed', 'seed', '{"fill_columns": 1, "steps": [{"title": "Dados", "columns": 2, "fields": [{"name": "data", "label": "Data", "type": "date", "required": true}, {"name": "turno", "label": "Turno", "type": "select", "options": ["Manhã", "Tarde", "Noite"], "required": true}, {"name": "responsavel", "label": "Responsável", "type": "text", "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "status", "label": "Status", "type": "select", "options": ["Conforme", "Parcial", "Não conforme", "Fechado"], "required": true, "editable_by": ["qualidade", "supervisor"]}, {"name": "owner_role", "label": "Dono atual (setor)", "type": "select", "options": ["recebimento", "qualidade", "supervisor"], "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "descricao", "label": "Descrição", "type": "textarea", "required": false}, {"name": "anexo", "label": "Anexo", "type": "file", "required": false}, {"name": "assinatura", "label": "Assinatura", "type": "signature", "required": false}]}]}', NOW());
INSERT INTO forms (id, name, slug, category_id, schema_json, html_layout, created_at) VALUES (6, 'Higiene e 5S', 'higiene-e-5s', 4, '{"fill_columns": 1, "steps": [{"title": "Dados", "columns": 2, "fields": [{"name": "data", "label": "Data", "type": "date", "required": true}, {"name": "turno", "label": "Turno", "type": "select", "options": ["Manhã", "Tarde", "Noite"], "required": true}, {"name": "responsavel", "label": "Responsável", "type": "text", "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "status", "label": "Status", "type": "select", "options": ["Conforme", "Parcial", "Não conforme", "Fechado"], "required": true, "editable_by": ["qualidade", "supervisor"]}, {"name": "owner_role", "label": "Dono atual (setor)", "type": "select", "options": ["recebimento", "qualidade", "supervisor"], "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "descricao", "label": "Descrição", "type": "textarea", "required": false}, {"name": "anexo", "label": "Anexo", "type": "file", "required": false}, {"name": "assinatura", "label": "Assinatura", "type": "signature", "required": false}]}]}', '<!— cole tudo no Editor de Layout —>
<div class="sheet" id="sheet" data-status="{{status}}" data-tema="light">
  <header class="print-header">
    <div class="left">
      <img src="{{logo_url}}" alt="logo" onerror="this.style.display=''none''" />
      <span class="empresa">{{empresa}}</span>
      <span class="form-name">{{form_name}}</span>
    </div>
    <div class="right">
      <div><strong>Protocolo:</strong> <span id="proto">{{protocolo}}{{submission_id}}</span></div>
      <div><strong>Data:</strong> {{data}}</div>
    </div>
  </header>
  <footer class="print-footer">
    Gerado por <strong>{{usuario}}</strong> em <strong>{{impresso_em}}</strong>
    <span class="spacer"></span>
    <span class="page-counter">Página <span class="pageNumber"></span> / <span class="totalPages"></span></span>
  </footer>
  <div class="wm" id="wm">NÃO CONFORME</div>
  <div class="stamp" id="stamp">{{status}}</div>
  <div class="actions no-print">
    <button class="btn" onclick="toggleTheme()">Alternar tema</button>
    <button class="btn" onclick="window.print()">Imprimir</button>
  </div>
  <section class="grid2 card">
    <div><label>Responsável</label><div class="val">{{responsavel}}</div></div>
    <div><label>Setor atual</label><div class="val">{{owner_role}}</div></div>
    <div><label>Status</label><div class="val">{{status}}</div></div>
    <div><label>Turno</label><div class="val">{{turno}}</div></div>
  </section>
  <section class="card">
    <h3>Descrição</h3>
    <div class="pre">{{descricao}}</div>
  </section>
  <section class="card">
    <h3>Itens</h3>
    <table class="tbl" id="tbl-itens">
      <thead><tr><th>Item</th><th class="num">Qtde</th><th>Unid</th></tr></thead>
      <tbody>
        {{#each itens}}
          <tr><td>{{descricao}}</td><td class="num">{{qtde}}</td><td>{{un}}</td></tr>
        {{/each}}
      </tbody>
      <tfoot><tr><th>Total</th><th class="num">{{sum itens.qtde}}</th><th></th></tr></tfoot>
    </table>
  </section>
  <section class="card">
    <h3>Fotos</h3>
    <div class="fotos" id="fotos"></div>
    <small class="muted">Use o campo <em>fotos_urls</em> com URLs separadas por vírgula.</small>
  </section>
  <section class="card assinaturas">
    <div class="sig">
      <div class="line"><img src="{{assinatura_recebimento}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Recebimento — {{nome_recebimento}} — {{data_recebimento}}</div>
    </div>
    <div class="sig">
      <div class="line"><img src="{{assinatura_qualidade}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Qualidade — {{nome_qualidade}} — {{data_qualidade}}</div>
    </div>
    <div class="sig">
      <div class="line"><img src="{{assinatura_supervisor}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Supervisor — {{nome_supervisor}} — {{data_supervisor}}</div>
    </div>
    <div class="sig">
      <div class="line"><img src="{{assinatura}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Assinatura</div>
    </div>
  </section>
  <section class="card">
    <div class="carimbo">
      <div class="carimbo-inner">
        <strong>{{empresa}}</strong><br>
        CNPJ: {{cnpj}}<br>
        {{endereco}}
      </div>
    </div>
  </section>
  <section class="card grid2">
    <div>
      <h4>Verificação</h4>
      <canvas id="qrcode" width="110" height="110"></canvas>
      <div class="muted">Abra com a câmera para validar</div>
    </div>
    <div>
      <h4>Protocolo</h4>
      <svg id="barcode"></svg>
    </div>
  </section>
</div>
<style>
:root{
  --bg:#ffffff; --fg:#1f2937; --muted:#6b7280; --border:#e5e7eb; --card:#fff; --surface:#f7f8fa;
  --ok:#2e7d32; --warn:#f9a825; --err:#c62828; --brand:#1976d2;
}
[data-theme="dark"], [data-tema="dark"]{
  --bg:#0b1220; --fg:#e5e7eb; --muted:#9ca3af; --border:#344054; --card:#0f172a; --surface:#0d1425;
}
*{box-sizing:border-box}
body{background:var(--surface)}
.sheet{color:var(--fg); background:var(--bg); max-width:900px; margin:0 auto; padding:16px 18px 24px; position:relative}
.print-header,.print-footer{position:sticky; z-index:5; background:var(--bg); color:var(--fg)}
.print-header{top:0; display:flex; align-items:center; justify-content:space-between; border-bottom:1px solid var(--border); padding-bottom:8px; margin-bottom:12px}
.print-header img{height:28px; margin-right:8px}
.print-header .empresa{margin-left:6px; font-weight:600}
.print-header .form-name{margin-left:10px; color:var(--muted)}
.print-footer{bottom:0; display:flex; align-items:center; gap:8px; border-top:1px solid var(--border); padding-top:6px; margin-top:16px; font-size:12px}
.spacer{flex:1}
.no-print{margin:8px 0 12px; display:flex; gap:8px}
.btn{padding:6px 10px; border:1px solid var(--border); background:var(--card); color:var(--fg); border-radius:8px; cursor:pointer}
.btn:hover{background:#eef2f7}
.card{border:1px solid var(--border); background:var(--card); border-radius:12px; padding:12px; margin:10px 0}
.grid2{display:grid; grid-template-columns:1fr 1fr; gap:12px}
@media (max-width:760px){ .grid2{grid-template-columns:1fr} }
label{display:block; font-size:12px; color:var(--muted); margin-bottom:2px}
.val{font-weight:600}
.pre{white-space:pre-wrap}
.tbl{width:100%; border-collapse:collapse}
.tbl th,.tbl td{border:1px solid var(--border); padding:6px}
.tbl .num{text-align:right}
.fotos{display:grid; grid-template-columns:repeat(3,1fr); gap:10px}
.fotos img{width:100%; height:160px; object-fit:cover; border:1px solid var(--border); border-radius:6px}
@media (max-width:900px){ .fotos{grid-template-columns:repeat(2,1fr)} }
@media (max-width:600px){ .fotos{grid-template-columns:1fr} }
.assinaturas{display:grid; grid-template-columns:repeat(2,1fr); gap:14px}
@media (max-width:760px){ .assinaturas{grid-template-columns:1fr} }
.sig .line{height:50px; border-bottom:1px solid var(--fg); display:flex; align-items:center}
.sig img{height:46px; max-width:100%; object-fit:contain}
.sig .legend{font-size:12px; color:var(--muted); margin-top:4px}
.carimbo{display:flex; justify-content:flex-start}
.carimbo-inner{border:2px solid var(--fg); padding:8px 12px; border-radius:8px; display:inline-block}
.stamp{position:absolute; top:90px; right:24px; font-weight:800; padding:6px 10px; border:2px solid currentColor; border-radius:8px; transform:rotate(-8deg)}
.wm{position:fixed; inset:0; display:none; align-items:center; justify-content:center; font:800 90px/1 Inter,system-ui; color:#0002; transform:rotate(-25deg); pointer-events:none; z-index:0}
@media print{
  .no-print{display:none !important}
  .print-header{position:fixed; top:0; left:0; right:0}
  .print-footer{position:fixed; bottom:0; left:0; right:0}
  .sheet{padding-top:70px; padding-bottom:55px}
}
</style>
<script src="https://cdn.jsdelivr.net/npm/qrcode@1.5.3/build/qrcode.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.6/dist/JsBarcode.all.min.js"></script>
<script>
(function(){
  const sheet = document.getElementById(''sheet'');
  const saved = localStorage.getItem(''layout_theme'');
  if(saved) sheet.setAttribute(''data-tema'', saved);
  window.toggleTheme = function(){
    const cur = sheet.getAttribute(''data-tema'') === ''dark'' ? ''light'' : ''dark'';
    sheet.setAttribute(''data-tema'', cur);
    localStorage.setItem(''layout_theme'', cur);
  };
  const statusRaw = (sheet.getAttribute(''data-status'') || '''').toLowerCase().normalize(''NFD'').replace(/\p{Diacritic}/gu,'''');
  const stamp = document.getElementById(''stamp'');
  if (stamp){
    stamp.className = ''stamp'';
    if (statusRaw.includes(''conforme'') && !statusRaw.includes(''nao'')) stamp.style.color = ''#2e7d32'';
    else if (statusRaw.includes(''parcial'')) stamp.style.color = ''#f9a825'';
    else if (statusRaw.includes(''nao'') || statusRaw.includes(''reprov'')) stamp.style.color = ''#c62828'';
  }
  const wm = document.getElementById(''wm'');
  if (wm){
    wm.style.display = (statusRaw.includes(''nao'') || statusRaw.includes(''reprov'')) ? ''flex'' : ''none'';
  }
  try{
    const base = "{{base_url}}".trim() || (location.origin + location.pathname.replace(/\/[^\/]*$/,''''));
    const sid  = "{{submission_id}}".trim() || document.getElementById(''proto'').textContent.trim();
    const veri = "{{veri_hash}}".trim();
    const url  = veri ? `${base}/submission_view.php?id=${encodeURIComponent(sid)}&h=${encodeURIComponent(veri)}`
                      : `${base}/submission_view.php?id=${encodeURIComponent(sid)}`;
    const canvas = document.getElementById(''qrcode'');
    if (canvas && typeof QRCode !== ''undefined'') { QRCode.toCanvas(canvas, url, { width: 110, margin: 1 }); }
  }catch(e){}
  try{
    const proto = document.getElementById(''proto'')?.textContent?.trim() || '''';
    if (proto && typeof JsBarcode !== ''undefined'') { JsBarcode("#barcode", proto, { format:"CODE128", height:32, displayValue:true }); }
  }catch(e){}
  (function(){
    const el = document.getElementById(''fotos'');
    if (!el) return;
    const listRaw = `{{fotos_urls}}`;
    if (!listRaw || listRaw.includes(''{{'')) { el.innerHTML = ''<span class="muted">Sem fotos</span>''; return; }
    const urls = listRaw.split('','').map(s=>s.trim()).filter(Boolean);
    if (!urls.length){ el.innerHTML = ''<span class="muted">Sem fotos</span>''; return; }
    el.innerHTML = urls.map(u => `<img src="${u}" alt="foto" onerror="this.style.display=''none''">`).join('''');
  })();
})();
</script>
', NOW());
INSERT INTO form_versions (form_id, user, note, schema_json, created_at) VALUES (6, 'seed', 'seed', '{"fill_columns": 1, "steps": [{"title": "Dados", "columns": 2, "fields": [{"name": "data", "label": "Data", "type": "date", "required": true}, {"name": "turno", "label": "Turno", "type": "select", "options": ["Manhã", "Tarde", "Noite"], "required": true}, {"name": "responsavel", "label": "Responsável", "type": "text", "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "status", "label": "Status", "type": "select", "options": ["Conforme", "Parcial", "Não conforme", "Fechado"], "required": true, "editable_by": ["qualidade", "supervisor"]}, {"name": "owner_role", "label": "Dono atual (setor)", "type": "select", "options": ["recebimento", "qualidade", "supervisor"], "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "descricao", "label": "Descrição", "type": "textarea", "required": false}, {"name": "anexo", "label": "Anexo", "type": "file", "required": false}, {"name": "assinatura", "label": "Assinatura", "type": "signature", "required": false}]}]}', NOW());
INSERT INTO forms (id, name, slug, category_id, schema_json, html_layout, created_at) VALUES (7, 'Auditoria Interna', 'auditoria-interna', 5, '{"fill_columns": 1, "steps": [{"title": "Dados", "columns": 2, "fields": [{"name": "data", "label": "Data", "type": "date", "required": true}, {"name": "turno", "label": "Turno", "type": "select", "options": ["Manhã", "Tarde", "Noite"], "required": true}, {"name": "responsavel", "label": "Responsável", "type": "text", "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "status", "label": "Status", "type": "select", "options": ["Conforme", "Parcial", "Não conforme", "Fechado"], "required": true, "editable_by": ["qualidade", "supervisor"]}, {"name": "owner_role", "label": "Dono atual (setor)", "type": "select", "options": ["recebimento", "qualidade", "supervisor"], "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "descricao", "label": "Descrição", "type": "textarea", "required": false}, {"name": "anexo", "label": "Anexo", "type": "file", "required": false}, {"name": "assinatura", "label": "Assinatura", "type": "signature", "required": false}]}]}', '<!— cole tudo no Editor de Layout —>
<div class="sheet" id="sheet" data-status="{{status}}" data-tema="light">
  <header class="print-header">
    <div class="left">
      <img src="{{logo_url}}" alt="logo" onerror="this.style.display=''none''" />
      <span class="empresa">{{empresa}}</span>
      <span class="form-name">{{form_name}}</span>
    </div>
    <div class="right">
      <div><strong>Protocolo:</strong> <span id="proto">{{protocolo}}{{submission_id}}</span></div>
      <div><strong>Data:</strong> {{data}}</div>
    </div>
  </header>
  <footer class="print-footer">
    Gerado por <strong>{{usuario}}</strong> em <strong>{{impresso_em}}</strong>
    <span class="spacer"></span>
    <span class="page-counter">Página <span class="pageNumber"></span> / <span class="totalPages"></span></span>
  </footer>
  <div class="wm" id="wm">NÃO CONFORME</div>
  <div class="stamp" id="stamp">{{status}}</div>
  <div class="actions no-print">
    <button class="btn" onclick="toggleTheme()">Alternar tema</button>
    <button class="btn" onclick="window.print()">Imprimir</button>
  </div>
  <section class="grid2 card">
    <div><label>Responsável</label><div class="val">{{responsavel}}</div></div>
    <div><label>Setor atual</label><div class="val">{{owner_role}}</div></div>
    <div><label>Status</label><div class="val">{{status}}</div></div>
    <div><label>Turno</label><div class="val">{{turno}}</div></div>
  </section>
  <section class="card">
    <h3>Descrição</h3>
    <div class="pre">{{descricao}}</div>
  </section>
  <section class="card">
    <h3>Itens</h3>
    <table class="tbl" id="tbl-itens">
      <thead><tr><th>Item</th><th class="num">Qtde</th><th>Unid</th></tr></thead>
      <tbody>
        {{#each itens}}
          <tr><td>{{descricao}}</td><td class="num">{{qtde}}</td><td>{{un}}</td></tr>
        {{/each}}
      </tbody>
      <tfoot><tr><th>Total</th><th class="num">{{sum itens.qtde}}</th><th></th></tr></tfoot>
    </table>
  </section>
  <section class="card">
    <h3>Fotos</h3>
    <div class="fotos" id="fotos"></div>
    <small class="muted">Use o campo <em>fotos_urls</em> com URLs separadas por vírgula.</small>
  </section>
  <section class="card assinaturas">
    <div class="sig">
      <div class="line"><img src="{{assinatura_recebimento}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Recebimento — {{nome_recebimento}} — {{data_recebimento}}</div>
    </div>
    <div class="sig">
      <div class="line"><img src="{{assinatura_qualidade}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Qualidade — {{nome_qualidade}} — {{data_qualidade}}</div>
    </div>
    <div class="sig">
      <div class="line"><img src="{{assinatura_supervisor}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Supervisor — {{nome_supervisor}} — {{data_supervisor}}</div>
    </div>
    <div class="sig">
      <div class="line"><img src="{{assinatura}}" alt="" onerror="this.style.display=''none''"></div>
      <div class="legend">Assinatura</div>
    </div>
  </section>
  <section class="card">
    <div class="carimbo">
      <div class="carimbo-inner">
        <strong>{{empresa}}</strong><br>
        CNPJ: {{cnpj}}<br>
        {{endereco}}
      </div>
    </div>
  </section>
  <section class="card grid2">
    <div>
      <h4>Verificação</h4>
      <canvas id="qrcode" width="110" height="110"></canvas>
      <div class="muted">Abra com a câmera para validar</div>
    </div>
    <div>
      <h4>Protocolo</h4>
      <svg id="barcode"></svg>
    </div>
  </section>
</div>
<style>
:root{
  --bg:#ffffff; --fg:#1f2937; --muted:#6b7280; --border:#e5e7eb; --card:#fff; --surface:#f7f8fa;
  --ok:#2e7d32; --warn:#f9a825; --err:#c62828; --brand:#1976d2;
}
[data-theme="dark"], [data-tema="dark"]{
  --bg:#0b1220; --fg:#e5e7eb; --muted:#9ca3af; --border:#344054; --card:#0f172a; --surface:#0d1425;
}
*{box-sizing:border-box}
body{background:var(--surface)}
.sheet{color:var(--fg); background:var(--bg); max-width:900px; margin:0 auto; padding:16px 18px 24px; position:relative}
.print-header,.print-footer{position:sticky; z-index:5; background:var(--bg); color:var(--fg)}
.print-header{top:0; display:flex; align-items:center; justify-content:space-between; border-bottom:1px solid var(--border); padding-bottom:8px; margin-bottom:12px}
.print-header img{height:28px; margin-right:8px}
.print-header .empresa{margin-left:6px; font-weight:600}
.print-header .form-name{margin-left:10px; color:var(--muted)}
.print-footer{bottom:0; display:flex; align-items:center; gap:8px; border-top:1px solid var(--border); padding-top:6px; margin-top:16px; font-size:12px}
.spacer{flex:1}
.no-print{margin:8px 0 12px; display:flex; gap:8px}
.btn{padding:6px 10px; border:1px solid var(--border); background:var(--card); color:var(--fg); border-radius:8px; cursor:pointer}
.btn:hover{background:#eef2f7}
.card{border:1px solid var(--border); background:var(--card); border-radius:12px; padding:12px; margin:10px 0}
.grid2{display:grid; grid-template-columns:1fr 1fr; gap:12px}
@media (max-width:760px){ .grid2{grid-template-columns:1fr} }
label{display:block; font-size:12px; color:var(--muted); margin-bottom:2px}
.val{font-weight:600}
.pre{white-space:pre-wrap}
.tbl{width:100%; border-collapse:collapse}
.tbl th,.tbl td{border:1px solid var(--border); padding:6px}
.tbl .num{text-align:right}
.fotos{display:grid; grid-template-columns:repeat(3,1fr); gap:10px}
.fotos img{width:100%; height:160px; object-fit:cover; border:1px solid var(--border); border-radius:6px}
@media (max-width:900px){ .fotos{grid-template-columns:repeat(2,1fr)} }
@media (max-width:600px){ .fotos{grid-template-columns:1fr} }
.assinaturas{display:grid; grid-template-columns:repeat(2,1fr); gap:14px}
@media (max-width:760px){ .assinaturas{grid-template-columns:1fr} }
.sig .line{height:50px; border-bottom:1px solid var(--fg); display:flex; align-items:center}
.sig img{height:46px; max-width:100%; object-fit:contain}
.sig .legend{font-size:12px; color:var(--muted); margin-top:4px}
.carimbo{display:flex; justify-content:flex-start}
.carimbo-inner{border:2px solid var(--fg); padding:8px 12px; border-radius:8px; display:inline-block}
.stamp{position:absolute; top:90px; right:24px; font-weight:800; padding:6px 10px; border:2px solid currentColor; border-radius:8px; transform:rotate(-8deg)}
.wm{position:fixed; inset:0; display:none; align-items:center; justify-content:center; font:800 90px/1 Inter,system-ui; color:#0002; transform:rotate(-25deg); pointer-events:none; z-index:0}
@media print{
  .no-print{display:none !important}
  .print-header{position:fixed; top:0; left:0; right:0}
  .print-footer{position:fixed; bottom:0; left:0; right:0}
  .sheet{padding-top:70px; padding-bottom:55px}
}
</style>
<script src="https://cdn.jsdelivr.net/npm/qrcode@1.5.3/build/qrcode.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.6/dist/JsBarcode.all.min.js"></script>
<script>
(function(){
  const sheet = document.getElementById(''sheet'');
  const saved = localStorage.getItem(''layout_theme'');
  if(saved) sheet.setAttribute(''data-tema'', saved);
  window.toggleTheme = function(){
    const cur = sheet.getAttribute(''data-tema'') === ''dark'' ? ''light'' : ''dark'';
    sheet.setAttribute(''data-tema'', cur);
    localStorage.setItem(''layout_theme'', cur);
  };
  const statusRaw = (sheet.getAttribute(''data-status'') || '''').toLowerCase().normalize(''NFD'').replace(/\p{Diacritic}/gu,'''');
  const stamp = document.getElementById(''stamp'');
  if (stamp){
    stamp.className = ''stamp'';
    if (statusRaw.includes(''conforme'') && !statusRaw.includes(''nao'')) stamp.style.color = ''#2e7d32'';
    else if (statusRaw.includes(''parcial'')) stamp.style.color = ''#f9a825'';
    else if (statusRaw.includes(''nao'') || statusRaw.includes(''reprov'')) stamp.style.color = ''#c62828'';
  }
  const wm = document.getElementById(''wm'');
  if (wm){
    wm.style.display = (statusRaw.includes(''nao'') || statusRaw.includes(''reprov'')) ? ''flex'' : ''none'';
  }
  try{
    const base = "{{base_url}}".trim() || (location.origin + location.pathname.replace(/\/[^\/]*$/,''''));
    const sid  = "{{submission_id}}".trim() || document.getElementById(''proto'').textContent.trim();
    const veri = "{{veri_hash}}".trim();
    const url  = veri ? `${base}/submission_view.php?id=${encodeURIComponent(sid)}&h=${encodeURIComponent(veri)}`
                      : `${base}/submission_view.php?id=${encodeURIComponent(sid)}`;
    const canvas = document.getElementById(''qrcode'');
    if (canvas && typeof QRCode !== ''undefined'') { QRCode.toCanvas(canvas, url, { width: 110, margin: 1 }); }
  }catch(e){}
  try{
    const proto = document.getElementById(''proto'')?.textContent?.trim() || '''';
    if (proto && typeof JsBarcode !== ''undefined'') { JsBarcode("#barcode", proto, { format:"CODE128", height:32, displayValue:true }); }
  }catch(e){}
  (function(){
    const el = document.getElementById(''fotos'');
    if (!el) return;
    const listRaw = `{{fotos_urls}}`;
    if (!listRaw || listRaw.includes(''{{'')) { el.innerHTML = ''<span class="muted">Sem fotos</span>''; return; }
    const urls = listRaw.split('','').map(s=>s.trim()).filter(Boolean);
    if (!urls.length){ el.innerHTML = ''<span class="muted">Sem fotos</span>''; return; }
    el.innerHTML = urls.map(u => `<img src="${u}" alt="foto" onerror="this.style.display=''none''">`).join('''');
  })();
})();
</script>
', NOW());
INSERT INTO form_versions (form_id, user, note, schema_json, created_at) VALUES (7, 'seed', 'seed', '{"fill_columns": 1, "steps": [{"title": "Dados", "columns": 2, "fields": [{"name": "data", "label": "Data", "type": "date", "required": true}, {"name": "turno", "label": "Turno", "type": "select", "options": ["Manhã", "Tarde", "Noite"], "required": true}, {"name": "responsavel", "label": "Responsável", "type": "text", "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "status", "label": "Status", "type": "select", "options": ["Conforme", "Parcial", "Não conforme", "Fechado"], "required": true, "editable_by": ["qualidade", "supervisor"]}, {"name": "owner_role", "label": "Dono atual (setor)", "type": "select", "options": ["recebimento", "qualidade", "supervisor"], "required": true, "editable_by": ["recebimento", "qualidade", "supervisor"]}, {"name": "descricao", "label": "Descrição", "type": "textarea", "required": false}, {"name": "anexo", "label": "Anexo", "type": "file", "required": false}, {"name": "assinatura", "label": "Assinatura", "type": "signature", "required": false}]}]}', NOW());
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (1, 1, 'Roberta', '2025-09-16 04:12:36', '2025-09-16 09:12:36', 'Roberta');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (1, 'data', '2025-09-19');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (1, 'turno', 'Manhã');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (1, 'responsavel', 'Roberta');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (1, 'status', 'Conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (1, 'owner_role', 'qualidade');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (1, 'descricao', 'Registro demo 1 do formulário 1.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (1, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (1, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (2, 1, 'Marcelo', '2025-09-16 09:12:36', '2025-09-16 14:12:36', 'Marcelo');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (2, 'data', '2025-09-18');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (2, 'turno', 'Noite');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (2, 'responsavel', 'Marcelo');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (2, 'status', 'Parcial');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (2, 'owner_role', 'recebimento');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (2, 'descricao', 'Registro demo 2 do formulário 1.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (2, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (2, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (3, 1, 'Roberta', '2025-09-16 14:12:36', '2025-09-16 19:12:36', 'Roberta');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (3, 'data', '2025-09-19');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (3, 'turno', 'Tarde');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (3, 'responsavel', 'Roberta');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (3, 'status', 'Não conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (3, 'owner_role', 'recebimento');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (3, 'descricao', 'Registro demo 3 do formulário 1.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (3, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (3, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (4, 1, 'Beatriz', '2025-09-16 19:12:36', '2025-09-17 00:12:36', 'Beatriz');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (4, 'data', '2025-09-14');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (4, 'turno', 'Tarde');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (4, 'responsavel', 'Beatriz');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (4, 'status', 'Não conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (4, 'owner_role', 'recebimento');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (4, 'descricao', 'Registro demo 4 do formulário 1.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (4, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (4, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (5, 1, 'Carlos', '2025-09-17 00:12:36', '2025-09-17 05:12:36', 'Carlos');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (5, 'data', '2025-09-19');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (5, 'turno', 'Manhã');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (5, 'responsavel', 'Carlos');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (5, 'status', 'Conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (5, 'owner_role', 'recebimento');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (5, 'descricao', 'Registro demo 5 do formulário 1.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (5, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (5, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (6, 1, 'Paulo', '2025-09-17 05:12:36', '2025-09-17 10:12:36', 'Paulo');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (6, 'data', '2025-09-20');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (6, 'turno', 'Tarde');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (6, 'responsavel', 'Paulo');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (6, 'status', 'Parcial');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (6, 'owner_role', 'supervisor');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (6, 'descricao', 'Registro demo 6 do formulário 1.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (6, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (6, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (7, 1, 'Marina', '2025-09-17 10:12:36', '2025-09-17 15:12:36', 'Marina');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (7, 'data', '2025-09-18');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (7, 'turno', 'Manhã');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (7, 'responsavel', 'Marina');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (7, 'status', 'Não conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (7, 'owner_role', 'recebimento');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (7, 'descricao', 'Registro demo 7 do formulário 1.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (7, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (7, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (8, 2, 'Rafael', '2025-09-17 15:12:36', '2025-09-17 20:12:36', 'Rafael');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (8, 'data', '2025-09-19');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (8, 'turno', 'Tarde');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (8, 'responsavel', 'Rafael');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (8, 'status', 'Parcial');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (8, 'owner_role', 'recebimento');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (8, 'descricao', 'Registro demo 1 do formulário 2.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (8, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (8, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (9, 2, 'Ana', '2025-09-17 20:12:36', '2025-09-18 01:12:36', 'Ana');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (9, 'data', '2025-09-19');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (9, 'turno', 'Noite');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (9, 'responsavel', 'Ana');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (9, 'status', 'Parcial');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (9, 'owner_role', 'qualidade');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (9, 'descricao', 'Registro demo 2 do formulário 2.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (9, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (9, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (10, 2, 'Ana', '2025-09-18 01:12:36', '2025-09-18 06:12:36', 'Ana');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (10, 'data', '2025-09-20');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (10, 'turno', 'Tarde');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (10, 'responsavel', 'Ana');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (10, 'status', 'Parcial');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (10, 'owner_role', 'recebimento');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (10, 'descricao', 'Registro demo 3 do formulário 2.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (10, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (10, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (11, 2, 'Paulo', '2025-09-18 06:12:36', '2025-09-18 11:12:36', 'Paulo');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (11, 'data', '2025-09-17');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (11, 'turno', 'Manhã');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (11, 'responsavel', 'Paulo');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (11, 'status', 'Parcial');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (11, 'owner_role', 'supervisor');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (11, 'descricao', 'Registro demo 4 do formulário 2.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (11, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (11, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (12, 2, 'Beatriz', '2025-09-18 11:12:36', '2025-09-18 16:12:36', 'Beatriz');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (12, 'data', '2025-09-20');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (12, 'turno', 'Noite');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (12, 'responsavel', 'Beatriz');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (12, 'status', 'Parcial');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (12, 'owner_role', 'qualidade');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (12, 'descricao', 'Registro demo 5 do formulário 2.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (12, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (12, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (13, 2, 'Paulo', '2025-09-18 16:12:36', '2025-09-18 21:12:36', 'Paulo');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (13, 'data', '2025-09-16');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (13, 'turno', 'Tarde');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (13, 'responsavel', 'Paulo');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (13, 'status', 'Conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (13, 'owner_role', 'qualidade');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (13, 'descricao', 'Registro demo 6 do formulário 2.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (13, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (13, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (14, 2, 'Marcelo', '2025-09-18 21:12:36', '2025-09-19 02:12:36', 'Marcelo');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (14, 'data', '2025-09-17');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (14, 'turno', 'Manhã');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (14, 'responsavel', 'Marcelo');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (14, 'status', 'Conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (14, 'owner_role', 'qualidade');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (14, 'descricao', 'Registro demo 7 do formulário 2.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (14, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (14, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (15, 3, 'Maria', '2025-09-19 02:12:36', '2025-09-19 07:12:36', 'Maria');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (15, 'data', '2025-09-16');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (15, 'turno', 'Tarde');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (15, 'responsavel', 'Maria');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (15, 'status', 'Parcial');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (15, 'owner_role', 'supervisor');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (15, 'descricao', 'Registro demo 1 do formulário 3.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (15, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (15, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (16, 3, 'Marcelo', '2025-09-19 07:12:36', '2025-09-19 12:12:36', 'Marcelo');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (16, 'data', '2025-09-14');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (16, 'turno', 'Manhã');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (16, 'responsavel', 'Marcelo');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (16, 'status', 'Não conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (16, 'owner_role', 'qualidade');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (16, 'descricao', 'Registro demo 2 do formulário 3.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (16, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (16, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (17, 3, 'Rafael', '2025-09-19 12:12:36', '2025-09-19 17:12:36', 'Rafael');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (17, 'data', '2025-09-17');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (17, 'turno', 'Noite');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (17, 'responsavel', 'Rafael');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (17, 'status', 'Não conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (17, 'owner_role', 'qualidade');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (17, 'descricao', 'Registro demo 3 do formulário 3.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (17, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (17, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (18, 3, 'João', '2025-09-19 17:12:36', '2025-09-19 22:12:36', 'João');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (18, 'data', '2025-09-16');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (18, 'turno', 'Tarde');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (18, 'responsavel', 'João');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (18, 'status', 'Não conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (18, 'owner_role', 'recebimento');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (18, 'descricao', 'Registro demo 4 do formulário 3.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (18, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (18, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (19, 3, 'João', '2025-09-19 22:12:36', '2025-09-20 03:12:36', 'João');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (19, 'data', '2025-09-14');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (19, 'turno', 'Manhã');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (19, 'responsavel', 'João');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (19, 'status', 'Parcial');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (19, 'owner_role', 'recebimento');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (19, 'descricao', 'Registro demo 5 do formulário 3.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (19, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (19, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (20, 3, 'Beatriz', '2025-09-20 03:12:36', '2025-09-20 08:12:36', 'Beatriz');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (20, 'data', '2025-09-14');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (20, 'turno', 'Manhã');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (20, 'responsavel', 'Beatriz');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (20, 'status', 'Conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (20, 'owner_role', 'recebimento');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (20, 'descricao', 'Registro demo 6 do formulário 3.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (20, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (20, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (21, 3, 'João', '2025-09-20 08:12:36', '2025-09-20 13:12:36', 'João');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (21, 'data', '2025-09-17');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (21, 'turno', 'Tarde');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (21, 'responsavel', 'João');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (21, 'status', 'Conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (21, 'owner_role', 'recebimento');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (21, 'descricao', 'Registro demo 7 do formulário 3.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (21, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (21, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (22, 4, 'Marina', '2025-09-20 13:12:36', '2025-09-20 18:12:36', 'Marina');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (22, 'data', '2025-09-19');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (22, 'turno', 'Tarde');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (22, 'responsavel', 'Marina');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (22, 'status', 'Parcial');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (22, 'owner_role', 'recebimento');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (22, 'descricao', 'Registro demo 1 do formulário 4.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (22, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (22, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (23, 4, 'Maria', '2025-09-20 18:12:36', '2025-09-20 23:12:36', 'Maria');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (23, 'data', '2025-09-16');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (23, 'turno', 'Manhã');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (23, 'responsavel', 'Maria');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (23, 'status', 'Parcial');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (23, 'owner_role', 'recebimento');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (23, 'descricao', 'Registro demo 2 do formulário 4.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (23, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (23, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (24, 4, 'Marcelo', '2025-09-20 23:12:36', '2025-09-21 04:12:36', 'Marcelo');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (24, 'data', '2025-09-15');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (24, 'turno', 'Manhã');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (24, 'responsavel', 'Marcelo');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (24, 'status', 'Não conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (24, 'owner_role', 'qualidade');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (24, 'descricao', 'Registro demo 3 do formulário 4.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (24, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (24, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (25, 4, 'Paulo', '2025-09-21 04:12:36', '2025-09-21 09:12:36', 'Paulo');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (25, 'data', '2025-09-16');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (25, 'turno', 'Tarde');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (25, 'responsavel', 'Paulo');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (25, 'status', 'Conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (25, 'owner_role', 'qualidade');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (25, 'descricao', 'Registro demo 4 do formulário 4.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (25, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (25, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (26, 4, 'Carlos', '2025-09-21 09:12:36', '2025-09-21 14:12:36', 'Carlos');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (26, 'data', '2025-09-16');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (26, 'turno', 'Noite');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (26, 'responsavel', 'Carlos');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (26, 'status', 'Não conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (26, 'owner_role', 'recebimento');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (26, 'descricao', 'Registro demo 5 do formulário 4.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (26, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (26, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (27, 4, 'João', '2025-09-21 14:12:36', '2025-09-21 19:12:36', 'João');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (27, 'data', '2025-09-17');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (27, 'turno', 'Manhã');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (27, 'responsavel', 'João');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (27, 'status', 'Parcial');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (27, 'owner_role', 'recebimento');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (27, 'descricao', 'Registro demo 6 do formulário 4.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (27, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (27, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (28, 4, 'Marina', '2025-09-21 19:12:36', '2025-09-22 00:12:36', 'Marina');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (28, 'data', '2025-09-15');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (28, 'turno', 'Noite');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (28, 'responsavel', 'Marina');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (28, 'status', 'Parcial');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (28, 'owner_role', 'supervisor');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (28, 'descricao', 'Registro demo 7 do formulário 4.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (28, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (28, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (29, 5, 'Carlos', '2025-09-22 00:12:36', '2025-09-22 05:12:36', 'Carlos');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (29, 'data', '2025-09-19');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (29, 'turno', 'Noite');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (29, 'responsavel', 'Carlos');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (29, 'status', 'Não conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (29, 'owner_role', 'recebimento');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (29, 'descricao', 'Registro demo 1 do formulário 5.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (29, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (29, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (30, 5, 'Marina', '2025-09-22 05:12:36', '2025-09-22 10:12:36', 'Marina');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (30, 'data', '2025-09-16');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (30, 'turno', 'Manhã');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (30, 'responsavel', 'Marina');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (30, 'status', 'Parcial');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (30, 'owner_role', 'recebimento');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (30, 'descricao', 'Registro demo 2 do formulário 5.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (30, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (30, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (31, 5, 'Roberta', '2025-09-22 10:12:36', '2025-09-22 15:12:36', 'Roberta');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (31, 'data', '2025-09-19');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (31, 'turno', 'Noite');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (31, 'responsavel', 'Roberta');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (31, 'status', 'Não conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (31, 'owner_role', 'recebimento');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (31, 'descricao', 'Registro demo 3 do formulário 5.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (31, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (31, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (32, 5, 'Maria', '2025-09-22 15:12:36', '2025-09-22 20:12:36', 'Maria');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (32, 'data', '2025-09-19');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (32, 'turno', 'Manhã');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (32, 'responsavel', 'Maria');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (32, 'status', 'Não conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (32, 'owner_role', 'qualidade');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (32, 'descricao', 'Registro demo 4 do formulário 5.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (32, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (32, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (33, 5, 'Roberta', '2025-09-22 20:12:36', '2025-09-23 01:12:36', 'Roberta');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (33, 'data', '2025-09-19');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (33, 'turno', 'Noite');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (33, 'responsavel', 'Roberta');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (33, 'status', 'Conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (33, 'owner_role', 'supervisor');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (33, 'descricao', 'Registro demo 5 do formulário 5.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (33, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (33, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (34, 5, 'Carlos', '2025-09-23 01:12:36', '2025-09-23 06:12:36', 'Carlos');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (34, 'data', '2025-09-14');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (34, 'turno', 'Noite');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (34, 'responsavel', 'Carlos');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (34, 'status', 'Conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (34, 'owner_role', 'qualidade');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (34, 'descricao', 'Registro demo 6 do formulário 5.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (34, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (34, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (35, 5, 'Rafael', '2025-09-23 06:12:36', '2025-09-23 11:12:36', 'Rafael');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (35, 'data', '2025-09-18');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (35, 'turno', 'Tarde');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (35, 'responsavel', 'Rafael');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (35, 'status', 'Não conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (35, 'owner_role', 'recebimento');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (35, 'descricao', 'Registro demo 7 do formulário 5.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (35, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (35, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (36, 6, 'Carlos', '2025-09-23 11:12:36', '2025-09-23 16:12:36', 'Carlos');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (36, 'data', '2025-09-17');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (36, 'turno', 'Noite');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (36, 'responsavel', 'Carlos');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (36, 'status', 'Parcial');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (36, 'owner_role', 'qualidade');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (36, 'descricao', 'Registro demo 1 do formulário 6.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (36, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (36, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (37, 6, 'Beatriz', '2025-09-23 16:12:36', '2025-09-23 21:12:36', 'Beatriz');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (37, 'data', '2025-09-16');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (37, 'turno', 'Manhã');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (37, 'responsavel', 'Beatriz');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (37, 'status', 'Conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (37, 'owner_role', 'qualidade');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (37, 'descricao', 'Registro demo 2 do formulário 6.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (37, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (37, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (38, 6, 'Marina', '2025-09-23 21:12:36', '2025-09-24 02:12:36', 'Marina');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (38, 'data', '2025-09-16');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (38, 'turno', 'Tarde');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (38, 'responsavel', 'Marina');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (38, 'status', 'Conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (38, 'owner_role', 'recebimento');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (38, 'descricao', 'Registro demo 3 do formulário 6.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (38, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (38, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (39, 6, 'Ana', '2025-09-24 02:12:36', '2025-09-24 07:12:36', 'Ana');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (39, 'data', '2025-09-14');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (39, 'turno', 'Noite');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (39, 'responsavel', 'Ana');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (39, 'status', 'Conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (39, 'owner_role', 'supervisor');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (39, 'descricao', 'Registro demo 4 do formulário 6.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (39, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (39, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (40, 6, 'Marina', '2025-09-24 07:12:36', '2025-09-24 12:12:36', 'Marina');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (40, 'data', '2025-09-15');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (40, 'turno', 'Noite');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (40, 'responsavel', 'Marina');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (40, 'status', 'Não conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (40, 'owner_role', 'supervisor');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (40, 'descricao', 'Registro demo 5 do formulário 6.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (40, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (40, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (41, 6, 'Roberta', '2025-09-24 12:12:36', '2025-09-24 17:12:36', 'Roberta');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (41, 'data', '2025-09-17');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (41, 'turno', 'Manhã');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (41, 'responsavel', 'Roberta');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (41, 'status', 'Não conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (41, 'owner_role', 'recebimento');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (41, 'descricao', 'Registro demo 6 do formulário 6.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (41, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (41, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (42, 6, 'Marcelo', '2025-09-24 17:12:36', '2025-09-24 22:12:36', 'Marcelo');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (42, 'data', '2025-09-14');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (42, 'turno', 'Tarde');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (42, 'responsavel', 'Marcelo');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (42, 'status', 'Conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (42, 'owner_role', 'qualidade');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (42, 'descricao', 'Registro demo 7 do formulário 6.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (42, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (42, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (43, 7, 'Maria', '2025-09-24 22:12:36', '2025-09-25 03:12:36', 'Maria');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (43, 'data', '2025-09-18');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (43, 'turno', 'Manhã');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (43, 'responsavel', 'Maria');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (43, 'status', 'Conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (43, 'owner_role', 'qualidade');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (43, 'descricao', 'Registro demo 1 do formulário 7.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (43, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (43, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (44, 7, 'Ana', '2025-09-25 03:12:36', '2025-09-25 08:12:36', 'Ana');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (44, 'data', '2025-09-15');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (44, 'turno', 'Manhã');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (44, 'responsavel', 'Ana');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (44, 'status', 'Conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (44, 'owner_role', 'recebimento');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (44, 'descricao', 'Registro demo 2 do formulário 7.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (44, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (44, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (45, 7, 'Paulo', '2025-09-25 08:12:36', '2025-09-25 13:12:36', 'Paulo');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (45, 'data', '2025-09-15');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (45, 'turno', 'Manhã');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (45, 'responsavel', 'Paulo');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (45, 'status', 'Conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (45, 'owner_role', 'qualidade');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (45, 'descricao', 'Registro demo 3 do formulário 7.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (45, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (45, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (46, 7, 'Paulo', '2025-09-25 13:12:36', '2025-09-25 18:12:36', 'Paulo');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (46, 'data', '2025-09-18');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (46, 'turno', 'Manhã');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (46, 'responsavel', 'Paulo');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (46, 'status', 'Não conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (46, 'owner_role', 'qualidade');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (46, 'descricao', 'Registro demo 4 do formulário 7.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (46, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (46, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (47, 7, 'Marcelo', '2025-09-25 18:12:36', '2025-09-25 23:12:36', 'Marcelo');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (47, 'data', '2025-09-15');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (47, 'turno', 'Noite');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (47, 'responsavel', 'Marcelo');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (47, 'status', 'Parcial');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (47, 'owner_role', 'qualidade');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (47, 'descricao', 'Registro demo 5 do formulário 7.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (47, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (47, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (48, 7, 'Roberta', '2025-09-25 23:12:36', '2025-09-26 04:12:36', 'Roberta');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (48, 'data', '2025-09-16');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (48, 'turno', 'Noite');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (48, 'responsavel', 'Roberta');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (48, 'status', 'Não conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (48, 'owner_role', 'qualidade');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (48, 'descricao', 'Registro demo 6 do formulário 7.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (48, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (48, 'assinatura', '');
INSERT INTO submissions (id, form_id, user, submitted_at, updated_at, updated_by) VALUES (49, 7, 'João', '2025-09-26 04:12:36', '2025-09-26 09:12:36', 'João');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (49, 'data', '2025-09-15');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (49, 'turno', 'Manhã');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (49, 'responsavel', 'João');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (49, 'status', 'Conforme');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (49, 'owner_role', 'supervisor');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (49, 'descricao', 'Registro demo 7 do formulário 7.');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (49, 'anexo', '');
INSERT INTO submission_values (submission_id, field_name, field_value) VALUES (49, 'assinatura', '');
